/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.local.CommandBuilder;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JavaCommandBuilder
implements CommandBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MAIN = "main";
    private static final String CLASSPATH = "classpath";
    private LocalDeployerProperties properties;

    public JavaCommandBuilder(LocalDeployerProperties properties) {
        this.properties = properties;
    }

    @Override
    public String[] buildExecutionCommand(AppDeploymentRequest request, Map<String, String> args) {
        ArrayList<String> commands = new ArrayList<String>();
        Map deploymentProperties = request.getDeploymentProperties();
        commands.add(this.properties.getJavaCmd());
        this.addJavaOptions(commands, deploymentProperties, this.properties);
        this.addJavaExecutionOptions(commands, request);
        commands.addAll(request.getCommandlineArguments());
        this.logger.debug("Java Command = " + commands);
        return commands.toArray(new String[0]);
    }

    protected void addJavaOptions(List<String> commands, Map<String, String> deploymentProperties, LocalDeployerProperties localDeployerProperties) {
        String javaOptsString;
        String memory = null;
        if (deploymentProperties.containsKey("spring.cloud.deployer.memory")) {
            memory = "-Xmx" + ByteSizeUtils.parseToMebibytes((String)deploymentProperties.get("spring.cloud.deployer.memory")) + "m";
        }
        if ((javaOptsString = this.getValue(deploymentProperties, "javaOpts")) == null && memory != null) {
            commands.add(memory);
        }
        if (javaOptsString != null) {
            boolean noJavaMemoryOption;
            String[] javaOpts = StringUtils.tokenizeToStringArray((String)javaOptsString, (String)" ");
            boolean bl = noJavaMemoryOption = !Stream.of(javaOpts).anyMatch(s -> s.startsWith("-Xmx"));
            if (noJavaMemoryOption && memory != null) {
                commands.add(memory);
            }
            commands.addAll(Arrays.asList(javaOpts));
        } else if (localDeployerProperties.getJavaOpts() != null) {
            String[] javaOpts = StringUtils.tokenizeToStringArray((String)localDeployerProperties.getJavaOpts(), (String)" ");
            commands.addAll(Arrays.asList(javaOpts));
        }
    }

    protected void addJavaExecutionOptions(List<String> commands, AppDeploymentRequest request) {
        Map deploymentProperties = request.getDeploymentProperties();
        if (this.containsKey(deploymentProperties, MAIN) || this.containsKey(deploymentProperties, CLASSPATH)) {
            Assert.isTrue((this.containsKey(deploymentProperties, MAIN) && this.containsKey(deploymentProperties, CLASSPATH) ? 1 : 0) != 0, (String)"spring.cloud.deployer.local.main and spring.cloud.deployer.local.classpath deployment properties are both required if either is provided.");
            commands.add("-cp");
            commands.add(this.getValue(deploymentProperties, CLASSPATH));
            commands.add(this.getValue(deploymentProperties, MAIN));
        } else {
            commands.add("-jar");
            Resource resource = request.getResource();
            try {
                commands.add(resource.getFile().getAbsolutePath());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private boolean containsKey(Map<String, String> deploymentProperties, String propertyName) {
        return deploymentProperties.containsKey("spring.cloud.deployer.local." + propertyName);
    }

    private String getValue(Map<String, String> deploymentProperties, String propertyName) {
        return deploymentProperties.get("spring.cloud.deployer.local." + propertyName);
    }
}

