/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.File;
import java.nio.file.Path;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.cloud.deployer.local")
public class LocalDeployerProperties {
    public static final String PREFIX = "spring.cloud.deployer.local";
    private Path workingDirectoriesRoot = new File(System.getProperty("java.io.tmpdir")).toPath();
    private boolean deleteFilesOnExit = true;
    private String[] envVarsToInherit = new String[]{"TMP", "LANG", "LANGUAGE", "LC_.*", "PATH"};
    private String javaCmd = this.deduceJavaCommand();
    private int shutdownTimeout = 30;
    private String javaOpts;

    public String getJavaCmd() {
        return this.javaCmd;
    }

    public void setJavaCmd(String javaCmd) {
        this.javaCmd = javaCmd;
    }

    public Path getWorkingDirectoriesRoot() {
        return this.workingDirectoriesRoot;
    }

    public void setWorkingDirectoriesRoot(String workingDirectoriesRoot) {
        this.workingDirectoriesRoot = new File(workingDirectoriesRoot).toPath();
    }

    public boolean isDeleteFilesOnExit() {
        return this.deleteFilesOnExit;
    }

    public void setDeleteFilesOnExit(boolean deleteFilesOnExit) {
        this.deleteFilesOnExit = deleteFilesOnExit;
    }

    public String[] getEnvVarsToInherit() {
        return this.envVarsToInherit;
    }

    public void setEnvVarsToInherit(String[] envVarsToInherit) {
        this.envVarsToInherit = envVarsToInherit;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public LocalDeployerProperties setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public void setJavaOpts(String javaOpts) {
        this.javaOpts = javaOpts;
    }

    private String deduceJavaCommand() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return "java";
        }
        File javaExecutable = new File(javaHome, "bin/java");
        if (javaExecutable.exists() && javaExecutable.canExecute()) {
            return javaExecutable.getAbsolutePath();
        }
        return "java";
    }
}

