/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.local;

import java.io.File;
import java.nio.file.Path;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="deployer.local")
public class LocalDeployerProperties {
    private Path workingDirectoriesRoot = new File(System.getProperty("java.io.tmpdir")).toPath();
    private boolean deleteFilesOnExit = true;
    private String[] envVarsToInherit = new String[]{"TMP", "LANG", "LANGUAGE", "LC_.*"};
    private String javaCmd = "java";
    private int shutdownTimeout = 30;

    public String getJavaCmd() {
        return this.javaCmd;
    }

    public void setJavaCmd(String javaCmd) {
        this.javaCmd = javaCmd;
    }

    public Path getWorkingDirectoriesRoot() {
        return this.workingDirectoriesRoot;
    }

    public void setWorkingDirectoriesRoot(Path workingDirectoriesRoot) {
        this.workingDirectoriesRoot = workingDirectoriesRoot;
    }

    public boolean isDeleteFilesOnExit() {
        return this.deleteFilesOnExit;
    }

    public void setDeleteFilesOnExit(boolean deleteFilesOnExit) {
        this.deleteFilesOnExit = deleteFilesOnExit;
    }

    public String[] getEnvVarsToInherit() {
        return this.envVarsToInherit;
    }

    public void setEnvVarsToInherit(String[] envVarsToInherit) {
        this.envVarsToInherit = envVarsToInherit;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public LocalDeployerProperties setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }
}

