/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.AffinityBuilder;
import io.fabric8.kubernetes.api.model.CapabilitiesBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapEnvSource;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.SecretEnvSource;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.SysctlBuilder;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeType;
import org.springframework.cloud.deployer.spi.kubernetes.RestartPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.support.PropertyParserUtils;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.cloud.deployer.spi.util.CommandLineTokenizer;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class DeploymentPropertiesResolver {
    static final String STATEFUL_SET_IMAGE_NAME = "busybox";
    private final Log logger = LogFactory.getLog((String)this.getClass().getName());
    private String propertyPrefix;
    private KubernetesDeployerProperties properties;

    DeploymentPropertiesResolver(String propertyPrefix, KubernetesDeployerProperties properties) {
        this.propertyPrefix = propertyPrefix;
        this.properties = properties;
    }

    String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    List<Toleration> getTolerations(Map<String, String> kubernetesDeployerProperties) {
        ArrayList<Toleration> tolerations = new ArrayList<Toleration>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".tolerations", "tolerations");
        deployerProperties.getTolerations().forEach(toleration -> tolerations.add(new Toleration(toleration.getEffect(), toleration.getKey(), toleration.getOperator(), toleration.getTolerationSeconds(), toleration.getValue())));
        this.properties.getTolerations().stream().filter(toleration -> tolerations.stream().noneMatch(existing -> existing.getKey().equals(toleration.getKey()))).collect(Collectors.toList()).forEach(toleration -> tolerations.add(new Toleration(toleration.getEffect(), toleration.getKey(), toleration.getOperator(), toleration.getTolerationSeconds(), toleration.getValue())));
        return tolerations;
    }

    List<Volume> getVolumes(Map<String, String> kubernetesDeployerProperties) {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".volumes", "volumes");
        volumes.addAll(deployerProperties.getVolumes());
        volumes.addAll(this.properties.getVolumes().stream().filter(volume -> volumes.stream().noneMatch(existingVolume -> existingVolume.getName().equals(volume.getName()))).collect(Collectors.toList()));
        return volumes;
    }

    Map<String, Quantity> deduceResourceLimits(Map<String, String> kubernetesDeployerProperties) {
        String gpuCount;
        String gpuVendor;
        String cpu;
        String memory = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".limits.memory");
        if (!StringUtils.hasText((String)memory)) {
            memory = this.properties.getLimits().getMemory();
        }
        if (!StringUtils.hasText((String)(cpu = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".limits.cpu")))) {
            cpu = this.properties.getLimits().getCpu();
        }
        if (!StringUtils.hasText((String)(gpuVendor = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".limits.gpuVendor")))) {
            gpuVendor = this.properties.getLimits().getGpuVendor();
        }
        if (!StringUtils.hasText((String)(gpuCount = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".limits.gpuCount")))) {
            gpuCount = this.properties.getLimits().getGpuCount();
        }
        HashMap<String, Quantity> limits = new HashMap<String, Quantity>();
        if (StringUtils.hasText((String)memory)) {
            limits.put("memory", new Quantity(memory));
        }
        if (StringUtils.hasText((String)cpu)) {
            limits.put("cpu", new Quantity(cpu));
        }
        if (StringUtils.hasText((String)gpuVendor) && StringUtils.hasText((String)gpuCount)) {
            limits.put(gpuVendor + "/gpu", new Quantity(gpuCount));
        }
        return limits;
    }

    ImagePullPolicy deduceImagePullPolicy(Map<String, String> kubernetesDeployerProperties) {
        ImagePullPolicy pullPolicy;
        String pullPolicyOverride = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".imagePullPolicy");
        if (pullPolicyOverride == null) {
            pullPolicy = this.properties.getImagePullPolicy();
        } else {
            pullPolicy = ImagePullPolicy.relaxedValueOf(pullPolicyOverride);
            if (pullPolicy == null) {
                this.logger.warn((Object)("Parsing of pull policy " + pullPolicyOverride + " failed, using default \"IfNotPresent\"."));
                pullPolicy = ImagePullPolicy.IfNotPresent;
            }
        }
        this.logger.debug((Object)("Using imagePullPolicy " + (Object)((Object)pullPolicy)));
        return pullPolicy;
    }

    Map<String, Quantity> deduceResourceRequests(Map<String, String> kubernetesDeployerProperties) {
        String cpuOverride;
        String memOverride = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".requests.memory");
        if (memOverride == null) {
            memOverride = this.properties.getRequests().getMemory();
        }
        if ((cpuOverride = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".requests.cpu")) == null) {
            cpuOverride = this.properties.getRequests().getCpu();
        }
        this.logger.debug((Object)("Using requests - cpu: " + cpuOverride + " mem: " + memOverride));
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>();
        if (memOverride != null) {
            requests.put("memory", new Quantity(memOverride));
        }
        if (cpuOverride != null) {
            requests.put("cpu", new Quantity(cpuOverride));
        }
        return requests;
    }

    String getStatefulSetVolumeClaimTemplateName(Map<String, String> kubernetesDeployerProperties) {
        String name = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".statefulSet.volumeClaimTemplate.name");
        if (name == null && this.properties.getStatefulSet() != null && this.properties.getStatefulSet().getVolumeClaimTemplate() != null) {
            name = this.properties.getStatefulSet().getVolumeClaimTemplate().getName();
        }
        return name;
    }

    String getStatefulSetStorageClassName(Map<String, String> kubernetesDeployerProperties) {
        String storageClassName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".statefulSet.volumeClaimTemplate.storageClassName");
        if (storageClassName == null && this.properties.getStatefulSet() != null && this.properties.getStatefulSet().getVolumeClaimTemplate() != null) {
            storageClassName = this.properties.getStatefulSet().getVolumeClaimTemplate().getStorageClassName();
        }
        return storageClassName;
    }

    String getStatefulSetStorage(Map<String, String> kubernetesDeployerProperties) {
        String storage = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".statefulSet.volumeClaimTemplate.storage");
        if (storage == null && this.properties.getStatefulSet() != null && this.properties.getStatefulSet().getVolumeClaimTemplate() != null) {
            storage = this.properties.getStatefulSet().getVolumeClaimTemplate().getStorage();
        }
        return ByteSizeUtils.parseToMebibytes((String)storage) + "Mi";
    }

    boolean getHostNetwork(Map<String, String> kubernetesDeployerProperties) {
        String hostNetworkOverride = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".hostNetwork");
        boolean hostNetwork = !StringUtils.hasText((String)hostNetworkOverride) ? this.properties.isHostNetwork() : Boolean.valueOf(hostNetworkOverride).booleanValue();
        this.logger.debug((Object)("Using hostNetwork " + hostNetwork));
        return hostNetwork;
    }

    Map<String, String> getNodeSelectors(Map<String, String> deploymentProperties) {
        HashMap<String, String> nodeSelectors = new HashMap<String, String>();
        String nodeSelector = this.properties.getNodeSelector();
        String nodeSelectorDeploymentProperty = deploymentProperties.getOrDefault("spring.cloud.deployer.kubernetes.deployment.nodeSelector", "");
        boolean hasGlobalNodeSelector = StringUtils.hasText((String)this.properties.getNodeSelector());
        boolean hasDeployerPropertyNodeSelector = StringUtils.hasText((String)nodeSelectorDeploymentProperty);
        if (hasGlobalNodeSelector && hasDeployerPropertyNodeSelector || !hasGlobalNodeSelector && hasDeployerPropertyNodeSelector) {
            nodeSelector = nodeSelectorDeploymentProperty;
        }
        if (StringUtils.hasText((String)nodeSelector)) {
            String[] nodeSelectorPairs;
            for (String nodeSelectorPair : nodeSelectorPairs = nodeSelector.split(",")) {
                String[] selector = nodeSelectorPair.split(":");
                Assert.isTrue((selector.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid nodeSelector value: '%s'", nodeSelectorPair));
                nodeSelectors.put(selector[0].trim(), selector[1].trim());
            }
        }
        return nodeSelectors;
    }

    String getImagePullSecret(Map<String, String> kubernetesDeployerProperties) {
        String imagePullSecret = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".imagePullSecret", "");
        if (!StringUtils.hasText((String)imagePullSecret)) {
            imagePullSecret = this.properties.getImagePullSecret();
        }
        return imagePullSecret;
    }

    List<String> getImagePullSecrets(Map<String, String> kubernetesDeployerProperties) {
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".imagePullSecrets", "imagePullSecrets");
        if (deployerProperties.getImagePullSecrets() == null || deployerProperties.getImagePullSecrets().isEmpty()) {
            return this.properties.getImagePullSecrets();
        }
        return deployerProperties.getImagePullSecrets();
    }

    String getDeploymentServiceAccountName(Map<String, String> kubernetesDeployerProperties) {
        String deploymentServiceAccountName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".deploymentServiceAccountName");
        if (!StringUtils.hasText((String)deploymentServiceAccountName)) {
            deploymentServiceAccountName = this.properties.getDeploymentServiceAccountName();
        }
        return deploymentServiceAccountName;
    }

    Boolean getShareProcessNamespace(Map<String, String> kubernetesDeployerProperties) {
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".shareProcessNamespace", "shareProcessNamespace");
        return deployerProperties.getShareProcessNamespace();
    }

    String getPriorityClassName(Map<String, String> kubernetesDeployerProperties) {
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".priorityClassName", "priorityClassName");
        return deployerProperties.getPriorityClassName();
    }

    PodSecurityContext getPodSecurityContext(Map<String, String> kubernetesDeployerProperties) {
        PodSecurityContext podSecurityContext = null;
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".podSecurityContext", "podSecurityContext");
        if (deployerProperties.getPodSecurityContext() != null) {
            podSecurityContext = this.buildPodSecurityContext(deployerProperties);
        } else if (this.properties.getPodSecurityContext() != null) {
            podSecurityContext = this.buildPodSecurityContext(this.properties);
        }
        return podSecurityContext;
    }

    private PodSecurityContext buildPodSecurityContext(KubernetesDeployerProperties deployerProperties) {
        PodSecurityContextBuilder podSecurityContextBuilder = (PodSecurityContextBuilder)((PodSecurityContextBuilder)((PodSecurityContextBuilder)((PodSecurityContextBuilder)((PodSecurityContextBuilder)((PodSecurityContextBuilder)new PodSecurityContextBuilder().withRunAsUser(deployerProperties.getPodSecurityContext().getRunAsUser())).withRunAsGroup(deployerProperties.getPodSecurityContext().getRunAsGroup())).withRunAsNonRoot(deployerProperties.getPodSecurityContext().getRunAsNonRoot())).withFsGroup(deployerProperties.getPodSecurityContext().getFsGroup())).withFsGroupChangePolicy(deployerProperties.getPodSecurityContext().getFsGroupChangePolicy())).withSupplementalGroups(deployerProperties.getPodSecurityContext().getSupplementalGroups());
        if (deployerProperties.getPodSecurityContext().getSeccompProfile() != null) {
            podSecurityContextBuilder.withNewSeccompProfile(deployerProperties.getPodSecurityContext().getSeccompProfile().getLocalhostProfile(), deployerProperties.getPodSecurityContext().getSeccompProfile().getType());
        }
        if (deployerProperties.getPodSecurityContext().getSeLinuxOptions() != null) {
            podSecurityContextBuilder.withNewSeLinuxOptions(deployerProperties.getPodSecurityContext().getSeLinuxOptions().getLevel(), deployerProperties.getPodSecurityContext().getSeLinuxOptions().getRole(), deployerProperties.getPodSecurityContext().getSeLinuxOptions().getType(), deployerProperties.getPodSecurityContext().getSeLinuxOptions().getUser());
        }
        if (!CollectionUtils.isEmpty(deployerProperties.getPodSecurityContext().getSysctls())) {
            List sysctls = deployerProperties.getPodSecurityContext().getSysctls().stream().map(sysctlInfo -> ((SysctlBuilder)((SysctlBuilder)new SysctlBuilder().withName(sysctlInfo.getName())).withValue(sysctlInfo.getValue())).build()).collect(Collectors.toList());
            podSecurityContextBuilder.withSysctls(sysctls);
        }
        if (deployerProperties.getPodSecurityContext().getWindowsOptions() != null) {
            podSecurityContextBuilder.withNewWindowsOptions(deployerProperties.getPodSecurityContext().getWindowsOptions().getGmsaCredentialSpec(), deployerProperties.getPodSecurityContext().getWindowsOptions().getGmsaCredentialSpecName(), deployerProperties.getPodSecurityContext().getWindowsOptions().getHostProcess(), deployerProperties.getPodSecurityContext().getWindowsOptions().getRunAsUserName());
        }
        return podSecurityContextBuilder.build();
    }

    SecurityContext getContainerSecurityContext(Map<String, String> kubernetesDeployerProperties) {
        SecurityContext securityContext = null;
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".containerSecurityContext", "containerSecurityContext");
        if (deployerProperties.getContainerSecurityContext() != null) {
            securityContext = this.buildContainerSecurityContext(deployerProperties);
        } else if (this.properties.getContainerSecurityContext() != null) {
            securityContext = this.buildContainerSecurityContext(this.properties);
        }
        return securityContext;
    }

    private SecurityContext buildContainerSecurityContext(KubernetesDeployerProperties deployerProperties) {
        SecurityContextBuilder securityContextBuilder = (SecurityContextBuilder)((SecurityContextBuilder)((SecurityContextBuilder)((SecurityContextBuilder)((SecurityContextBuilder)((SecurityContextBuilder)((SecurityContextBuilder)new SecurityContextBuilder().withAllowPrivilegeEscalation(deployerProperties.getContainerSecurityContext().getAllowPrivilegeEscalation())).withPrivileged(deployerProperties.getContainerSecurityContext().getPrivileged())).withProcMount(deployerProperties.getContainerSecurityContext().getProcMount())).withReadOnlyRootFilesystem(deployerProperties.getContainerSecurityContext().getReadOnlyRootFilesystem())).withRunAsUser(deployerProperties.getContainerSecurityContext().getRunAsUser())).withRunAsGroup(deployerProperties.getContainerSecurityContext().getRunAsGroup())).withRunAsNonRoot(deployerProperties.getContainerSecurityContext().getRunAsNonRoot());
        if (deployerProperties.getContainerSecurityContext().getCapabilities() != null) {
            securityContextBuilder.withCapabilities(((CapabilitiesBuilder)((CapabilitiesBuilder)new CapabilitiesBuilder().withAdd(deployerProperties.getContainerSecurityContext().getCapabilities().getAdd())).withDrop(deployerProperties.getContainerSecurityContext().getCapabilities().getDrop())).build());
        }
        if (deployerProperties.getContainerSecurityContext().getSeccompProfile() != null) {
            securityContextBuilder.withNewSeccompProfile(deployerProperties.getContainerSecurityContext().getSeccompProfile().getLocalhostProfile(), deployerProperties.getContainerSecurityContext().getSeccompProfile().getType());
        }
        if (deployerProperties.getContainerSecurityContext().getSeLinuxOptions() != null) {
            securityContextBuilder.withNewSeLinuxOptions(deployerProperties.getContainerSecurityContext().getSeLinuxOptions().getLevel(), deployerProperties.getContainerSecurityContext().getSeLinuxOptions().getRole(), deployerProperties.getContainerSecurityContext().getSeLinuxOptions().getType(), deployerProperties.getContainerSecurityContext().getSeLinuxOptions().getUser());
        }
        if (deployerProperties.getContainerSecurityContext().getWindowsOptions() != null) {
            securityContextBuilder.withNewWindowsOptions(deployerProperties.getContainerSecurityContext().getWindowsOptions().getGmsaCredentialSpec(), deployerProperties.getContainerSecurityContext().getWindowsOptions().getGmsaCredentialSpecName(), deployerProperties.getContainerSecurityContext().getWindowsOptions().getHostProcess(), deployerProperties.getContainerSecurityContext().getWindowsOptions().getRunAsUserName());
        }
        return securityContextBuilder.build();
    }

    Affinity getAffinityRules(Map<String, String> kubernetesDeployerProperties) {
        Affinity affinity = new Affinity();
        String nodeAffinityPropertyKey = this.propertyPrefix + ".affinity.nodeAffinity";
        String podAffinityPropertyKey = this.propertyPrefix + ".affinity.podAffinity";
        String podAntiAffinityPropertyKey = this.propertyPrefix + ".affinity.podAntiAffinity";
        String nodeAffinityValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, nodeAffinityPropertyKey);
        String podAffinityValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, podAffinityPropertyKey);
        String podAntiAffinityValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, podAntiAffinityPropertyKey);
        if (this.properties.getNodeAffinity() != null && !StringUtils.hasText((String)nodeAffinityValue)) {
            affinity.setNodeAffinity(((AffinityBuilder)new AffinityBuilder().withNodeAffinity(this.properties.getNodeAffinity())).buildNodeAffinity());
        } else if (StringUtils.hasText((String)nodeAffinityValue)) {
            KubernetesDeployerProperties nodeAffinityProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, nodeAffinityPropertyKey, "nodeAffinity");
            affinity.setNodeAffinity(((AffinityBuilder)new AffinityBuilder().withNodeAffinity(nodeAffinityProperties.getNodeAffinity())).buildNodeAffinity());
        }
        if (this.properties.getPodAffinity() != null && !StringUtils.hasText((String)podAffinityValue)) {
            affinity.setPodAffinity(((AffinityBuilder)new AffinityBuilder().withPodAffinity(this.properties.getPodAffinity())).buildPodAffinity());
        } else if (StringUtils.hasText((String)podAffinityValue)) {
            KubernetesDeployerProperties podAffinityProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, podAffinityPropertyKey, "podAffinity");
            affinity.setPodAffinity(((AffinityBuilder)new AffinityBuilder().withPodAffinity(podAffinityProperties.getPodAffinity())).buildPodAffinity());
        }
        if (this.properties.getPodAntiAffinity() != null && !StringUtils.hasText((String)podAntiAffinityValue)) {
            affinity.setPodAntiAffinity(((AffinityBuilder)new AffinityBuilder().withPodAntiAffinity(this.properties.getPodAntiAffinity())).buildPodAntiAffinity());
        } else if (StringUtils.hasText((String)podAntiAffinityValue)) {
            KubernetesDeployerProperties podAntiAffinityProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, podAntiAffinityPropertyKey, "podAntiAffinity");
            affinity.setPodAntiAffinity(((AffinityBuilder)new AffinityBuilder().withPodAntiAffinity(podAntiAffinityProperties.getPodAntiAffinity())).buildPodAntiAffinity());
        }
        return affinity;
    }

    Container getInitContainer(Map<String, String> kubernetesDeployerProperties) {
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(kubernetesDeployerProperties, this.propertyPrefix + ".initContainer", "initContainer");
        KubernetesDeployerProperties.InitContainer initContainerProps = deployerProperties.getInitContainer();
        if (initContainerProps != null) {
            return this.containerFromProps(initContainerProps);
        }
        String containerName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".initContainer.containerName");
        String imageName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".initContainer.imageName");
        if (StringUtils.hasText((String)containerName) && StringUtils.hasText((String)imageName)) {
            String commandsStr = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".initContainer.commands");
            List commands = StringUtils.hasText((String)commandsStr) ? Arrays.stream(commandsStr.split(",")).collect(Collectors.toList()) : Collections.emptyList();
            String envString = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".initContainer.environmentVariables");
            List<VolumeMount> vms = this.getInitContainerVolumeMounts(kubernetesDeployerProperties);
            return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(containerName)).withImage(imageName)).withCommand(commands)).withEnv(this.toEnvironmentVariables(envString != null ? envString.split(",") : new String[]{}))).addAllToVolumeMounts(vms)).build();
        }
        initContainerProps = this.properties.getInitContainer();
        if (initContainerProps != null) {
            return this.containerFromProps(initContainerProps);
        }
        return null;
    }

    private Container containerFromProps(KubernetesDeployerProperties.InitContainer initContainerProps) {
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(initContainerProps.getContainerName())).withImage(initContainerProps.getImageName())).withCommand(initContainerProps.getCommands())).withEnv(this.toEnvironmentVariables(initContainerProps.getEnvironmentVariables()))).addAllToVolumeMounts((Collection)Optional.ofNullable(initContainerProps.getVolumeMounts()).orElse(Collections.emptyList()))).build();
    }

    private List<EnvVar> toEnvironmentVariables(String[] environmentVariables) {
        HashMap<String, String> envVarsMap = new HashMap<String, String>();
        if (environmentVariables != null) {
            for (String envVar : environmentVariables) {
                String[] strings = envVar.split("=", 2);
                Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
                envVarsMap.put(strings[0], strings[1]);
            }
        }
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        for (Map.Entry e : envVarsMap.entrySet()) {
            envVars.add(new EnvVar((String)e.getKey(), (String)e.getValue(), null));
        }
        return envVars;
    }

    List<Container> getAdditionalContainers(Map<String, String> deploymentProperties) {
        ArrayList<Container> containers = new ArrayList<Container>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(deploymentProperties, this.propertyPrefix + ".additionalContainers", "additionalContainers");
        if (deployerProperties.getAdditionalContainers() != null) {
            deployerProperties.getAdditionalContainers().forEach(container -> containers.add((Container)container));
        }
        if (this.properties.getAdditionalContainers() != null) {
            this.properties.getAdditionalContainers().stream().filter(container -> containers.stream().noneMatch(existing -> existing.getName().equals(container.getName()))).forEachOrdered(container -> containers.add((Container)container));
        }
        return containers;
    }

    Map<String, String> getPodAnnotations(Map<String, String> kubernetesDeployerProperties) {
        String annotationsValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".podAnnotations", "");
        if (!StringUtils.hasText((String)annotationsValue)) {
            annotationsValue = this.properties.getPodAnnotations();
        }
        return PropertyParserUtils.getStringPairsToMap(annotationsValue);
    }

    Map<String, String> getServiceAnnotations(Map<String, String> kubernetesDeployerProperties) {
        String annotationsProperty = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".serviceAnnotations", "");
        if (!StringUtils.hasText((String)annotationsProperty)) {
            annotationsProperty = this.properties.getServiceAnnotations();
        }
        return PropertyParserUtils.getStringPairsToMap(annotationsProperty);
    }

    Map<String, String> getDeploymentLabels(Map<String, String> kubernetesDeployerProperties) {
        String updatedLabels;
        HashMap<String, String> labels = new HashMap<String, String>();
        String deploymentLabels = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".deploymentLabels", "");
        String string = StringUtils.hasText((String)this.properties.getDeploymentLabels()) ? deploymentLabels + (StringUtils.hasText((String)deploymentLabels) ? "," : "") + this.properties.getDeploymentLabels() : (updatedLabels = deploymentLabels);
        if (StringUtils.hasText((String)updatedLabels)) {
            String[] deploymentLabel;
            for (String label : deploymentLabel = updatedLabels.split(",")) {
                Object[] labelPair = label.split(":");
                Assert.isTrue((labelPair.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid label format, expected 'labelKey:labelValue', got: '%s'", labelPair));
                labels.put(((String)labelPair[0]).trim(), ((String)labelPair[1]).trim());
            }
        }
        return labels;
    }

    RestartPolicy getRestartPolicy(Map<String, String> kubernetesDeployerProperties) {
        String restartPolicy = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".restartPolicy", "");
        if (StringUtils.hasText((String)restartPolicy)) {
            return RestartPolicy.valueOf(restartPolicy);
        }
        return this.properties.getRestartPolicy();
    }

    String getTaskServiceAccountName(Map<String, String> kubernetesDeployerProperties) {
        String taskServiceAccountName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".taskServiceAccountName", "");
        if (StringUtils.hasText((String)taskServiceAccountName)) {
            return taskServiceAccountName;
        }
        return this.properties.getTaskServiceAccountName();
    }

    private static KubernetesDeployerProperties bindProperties(Map<String, String> kubernetesDeployerProperties, String propertyKey, String yamlLabel) {
        String deploymentPropertyValue = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, propertyKey);
        KubernetesDeployerProperties deployerProperties = new KubernetesDeployerProperties();
        if (StringUtils.hasText((String)deploymentPropertyValue)) {
            try {
                YamlPropertiesFactoryBean properties = new YamlPropertiesFactoryBean();
                String tmpYaml = "{ " + yamlLabel + ": " + deploymentPropertyValue + " }";
                properties.setResources(new Resource[]{new ByteArrayResource(tmpYaml.getBytes())});
                Properties yaml = properties.getObject();
                MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)yaml);
                deployerProperties = (KubernetesDeployerProperties)new Binder(new ConfigurationPropertySource[]{source}).bind("", Bindable.of(KubernetesDeployerProperties.class)).get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid binding property '%s'", deploymentPropertyValue), e);
            }
        }
        return deployerProperties;
    }

    String getStatefulSetInitContainerImageName(Map<String, String> kubernetesDeployerProperties) {
        String statefulSetInitContainerImageName = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".statefulSetInitContainerImageName", "");
        if (StringUtils.hasText((String)statefulSetInitContainerImageName)) {
            return statefulSetInitContainerImageName;
        }
        statefulSetInitContainerImageName = this.properties.getStatefulSetInitContainerImageName();
        if (StringUtils.hasText((String)statefulSetInitContainerImageName)) {
            return statefulSetInitContainerImageName;
        }
        return STATEFUL_SET_IMAGE_NAME;
    }

    Map<String, String> getJobAnnotations(Map<String, String> kubernetesDeployerProperties) {
        String annotationsProperty = PropertyParserUtils.getDeploymentPropertyValue(kubernetesDeployerProperties, this.propertyPrefix + ".jobAnnotations", "");
        if (!StringUtils.hasText((String)annotationsProperty)) {
            annotationsProperty = this.properties.getJobAnnotations();
        }
        return PropertyParserUtils.getStringPairsToMap(annotationsProperty);
    }

    List<VolumeMount> getVolumeMounts(Map<String, String> deploymentProperties) {
        return this.getVolumeMounts(PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".volumeMounts"));
    }

    private List<VolumeMount> getInitContainerVolumeMounts(Map<String, String> deploymentProperties) {
        return this.getVolumeMounts(PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".initContainer.volumeMounts"));
    }

    private List<VolumeMount> getVolumeMounts(String propertyValue) {
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        if (StringUtils.hasText((String)propertyValue)) {
            try {
                YamlPropertiesFactoryBean properties = new YamlPropertiesFactoryBean();
                String tmpYaml = "{ volume-mounts: " + propertyValue + " }";
                properties.setResources(new Resource[]{new ByteArrayResource(tmpYaml.getBytes())});
                Properties yaml = properties.getObject();
                MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)yaml);
                KubernetesDeployerProperties deployerProperties = (KubernetesDeployerProperties)new Binder(new ConfigurationPropertySource[]{source}).bind("", Bindable.of(KubernetesDeployerProperties.class)).get();
                volumeMounts.addAll(deployerProperties.getVolumeMounts());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid volume mount '%s'", propertyValue), e);
            }
        }
        volumeMounts.addAll(this.properties.getVolumeMounts().stream().filter(volumeMount -> volumeMounts.stream().noneMatch(existingVolumeMount -> existingVolumeMount.getName().equals(volumeMount.getName()))).collect(Collectors.toList()));
        return volumeMounts;
    }

    List<String> getContainerCommand(Map<String, String> deploymentProperties) {
        String containerCommand = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".containerCommand", "");
        return new CommandLineTokenizer(containerCommand).getArgs();
    }

    KubernetesDeployerProperties.Lifecycle getLifeCycle(Map<String, String> deploymentProperties) {
        String preStop;
        KubernetesDeployerProperties.Lifecycle lifecycle = this.properties.getLifecycle();
        if (deploymentProperties.keySet().stream().noneMatch(s -> s.startsWith(this.propertyPrefix + ".lifecycle"))) {
            return lifecycle;
        }
        String postStart = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".lifecycle.postStart.exec.command");
        if (StringUtils.hasText((String)postStart)) {
            lifecycle.setPostStart(this.lifecycleHook(postStart));
        }
        if (StringUtils.hasText((String)(preStop = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".lifecycle.preStop.exec.command")))) {
            lifecycle.setPreStop(this.lifecycleHook(preStop));
        }
        return lifecycle;
    }

    private KubernetesDeployerProperties.Lifecycle.Hook lifecycleHook(String command) {
        KubernetesDeployerProperties.Lifecycle.Hook hook = new KubernetesDeployerProperties.Lifecycle.Hook();
        KubernetesDeployerProperties.Lifecycle.Exec exec = new KubernetesDeployerProperties.Lifecycle.Exec();
        exec.setCommand(Arrays.asList(command.split(",")));
        hook.setExec(exec);
        return hook;
    }

    Long determineTerminationGracePeriodSeconds(Map<String, String> deploymentProperties) {
        String gracePeriodStr = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".terminationGracePeriodSeconds", null);
        if (gracePeriodStr != null) {
            return Long.parseLong(gracePeriodStr);
        }
        return this.properties.getTerminationGracePeriodSeconds();
    }

    List<Integer> getContainerPorts(Map<String, String> deploymentProperties) {
        ArrayList<Integer> containerPortList = new ArrayList<Integer>();
        String containerPorts = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".containerPorts", null);
        if (containerPorts != null) {
            String[] containerPortSplit;
            for (String containerPort : containerPortSplit = containerPorts.split(",")) {
                this.logger.trace((Object)("Adding container ports from AppDeploymentRequest: " + containerPort));
                Integer port = Integer.parseInt(containerPort.trim());
                containerPortList.add(port);
            }
        }
        return containerPortList;
    }

    Map<String, String> getAppEnvironmentVariables(Map<String, String> deploymentProperties) {
        HashMap<String, String> appEnvVarMap = new HashMap<String, String>();
        String appEnvVar = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".environmentVariables", null);
        if (appEnvVar != null) {
            String[] appEnvVars;
            for (String envVar : appEnvVars = new NestedCommaDelimitedVariableParser().parse(appEnvVar)) {
                this.logger.trace((Object)("Adding environment variable from AppDeploymentRequest: " + envVar));
                String[] strings = envVar.split("=", 2);
                Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
                appEnvVarMap.put(strings[0], strings[1]);
            }
        }
        return appEnvVarMap;
    }

    EntryPointStyle determineEntryPointStyle(Map<String, String> deploymentProperties) {
        EntryPointStyle entryPointStyle = null;
        String deployerPropertyValue = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".entryPointStyle", null);
        if (deployerPropertyValue != null) {
            try {
                entryPointStyle = EntryPointStyle.valueOf(deployerPropertyValue.toLowerCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (entryPointStyle == null) {
            entryPointStyle = this.properties.getEntryPointStyle();
        }
        return entryPointStyle;
    }

    ProbeType determineProbeType(Map<String, String> deploymentProperties) {
        ProbeType probeType = this.properties.getProbeType();
        String deployerPropertyValue = PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, this.propertyPrefix + ".probeType", null);
        if (StringUtils.hasText((String)deployerPropertyValue)) {
            probeType = ProbeType.valueOf(deployerPropertyValue.toUpperCase());
        }
        return probeType;
    }

    List<EnvVar> getConfigMapKeyRefs(Map<String, String> deploymentProperties) {
        ArrayList<EnvVar> configMapKeyRefs = new ArrayList<EnvVar>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(deploymentProperties, this.propertyPrefix + ".configMapKeyRefs", "configMapKeyRefs");
        deployerProperties.getConfigMapKeyRefs().forEach(configMapKeyRef -> configMapKeyRefs.add(this.buildConfigMapKeyRefEnvVar((KubernetesDeployerProperties.ConfigMapKeyRef)configMapKeyRef)));
        this.properties.getConfigMapKeyRefs().stream().filter(configMapKeyRef -> configMapKeyRefs.stream().noneMatch(existing -> existing.getName().equals(configMapKeyRef.getEnvVarName()))).collect(Collectors.toList()).forEach(configMapKeyRef -> configMapKeyRefs.add(this.buildConfigMapKeyRefEnvVar((KubernetesDeployerProperties.ConfigMapKeyRef)configMapKeyRef)));
        return configMapKeyRefs;
    }

    private EnvVar buildConfigMapKeyRefEnvVar(KubernetesDeployerProperties.ConfigMapKeyRef configMapKeyRef) {
        ConfigMapKeySelector configMapKeySelector = new ConfigMapKeySelector();
        EnvVarSource envVarSource = new EnvVarSource();
        envVarSource.setConfigMapKeyRef(configMapKeySelector);
        EnvVar configMapKeyEnvRefVar = new EnvVar();
        configMapKeyEnvRefVar.setValueFrom(envVarSource);
        configMapKeySelector.setName(configMapKeyRef.getConfigMapName());
        configMapKeySelector.setKey(configMapKeyRef.getDataKey());
        configMapKeyEnvRefVar.setName(configMapKeyRef.getEnvVarName());
        return configMapKeyEnvRefVar;
    }

    List<EnvVar> getSecretKeyRefs(Map<String, String> deploymentProperties) {
        ArrayList<EnvVar> secretKeyRefs = new ArrayList<EnvVar>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(deploymentProperties, this.propertyPrefix + ".secretKeyRefs", "secretKeyRefs");
        deployerProperties.getSecretKeyRefs().forEach(secretKeyRef -> secretKeyRefs.add(this.buildSecretKeyRefEnvVar((KubernetesDeployerProperties.SecretKeyRef)secretKeyRef)));
        this.properties.getSecretKeyRefs().stream().filter(secretKeyRef -> secretKeyRefs.stream().noneMatch(existing -> existing.getName().equals(secretKeyRef.getEnvVarName()))).collect(Collectors.toList()).forEach(secretKeyRef -> secretKeyRefs.add(this.buildSecretKeyRefEnvVar((KubernetesDeployerProperties.SecretKeyRef)secretKeyRef)));
        return secretKeyRefs;
    }

    private EnvVar buildSecretKeyRefEnvVar(KubernetesDeployerProperties.SecretKeyRef secretKeyRef) {
        SecretKeySelector secretKeySelector = new SecretKeySelector();
        EnvVarSource envVarSource = new EnvVarSource();
        envVarSource.setSecretKeyRef(secretKeySelector);
        EnvVar secretKeyEnvRefVar = new EnvVar();
        secretKeyEnvRefVar.setValueFrom(envVarSource);
        secretKeySelector.setName(secretKeyRef.getSecretName());
        secretKeySelector.setKey(secretKeyRef.getDataKey());
        secretKeyEnvRefVar.setName(secretKeyRef.getEnvVarName());
        return secretKeyEnvRefVar;
    }

    List<EnvFromSource> getConfigMapRefs(Map<String, String> deploymentProperties) {
        ArrayList<EnvFromSource> configMapRefs = new ArrayList<EnvFromSource>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(deploymentProperties, this.propertyPrefix + ".configMapRefs", "configMapRefs");
        deployerProperties.getConfigMapRefs().forEach(configMapRef -> configMapRefs.add(this.buildConfigMapRefEnvVar((String)configMapRef)));
        if (deployerProperties.getConfigMapRefs().isEmpty()) {
            this.properties.getConfigMapRefs().stream().filter(configMapRef -> configMapRefs.stream().noneMatch(existing -> existing.getConfigMapRef().getName().equals(configMapRef))).collect(Collectors.toList()).forEach(configMapRef -> configMapRefs.add(this.buildConfigMapRefEnvVar((String)configMapRef)));
        }
        return configMapRefs;
    }

    private EnvFromSource buildConfigMapRefEnvVar(String configMapRefName) {
        ConfigMapEnvSource configMapEnvSource = new ConfigMapEnvSource();
        configMapEnvSource.setName(configMapRefName);
        EnvFromSource envFromSource = new EnvFromSource();
        envFromSource.setConfigMapRef(configMapEnvSource);
        return envFromSource;
    }

    List<EnvFromSource> getSecretRefs(Map<String, String> deploymentProperties) {
        ArrayList<EnvFromSource> secretRefs = new ArrayList<EnvFromSource>();
        KubernetesDeployerProperties deployerProperties = DeploymentPropertiesResolver.bindProperties(deploymentProperties, this.propertyPrefix + ".secretRefs", "secretRefs");
        deployerProperties.getSecretRefs().forEach(secretRef -> secretRefs.add(this.buildSecretRefEnvVar((String)secretRef)));
        if (deployerProperties.getSecretRefs().isEmpty()) {
            this.properties.getSecretRefs().stream().filter(secretRef -> secretRefs.stream().noneMatch(existing -> existing.getSecretRef().getName().equals(secretRef))).collect(Collectors.toList()).forEach(secretRef -> secretRefs.add(this.buildSecretRefEnvVar((String)secretRef)));
        }
        return secretRefs;
    }

    private EnvFromSource buildSecretRefEnvVar(String secretRefName) {
        SecretEnvSource secretEnvSource = new SecretEnvSource();
        secretEnvSource.setName(secretRefName);
        EnvFromSource envFromSource = new EnvFromSource();
        envFromSource.setSecretRef(secretEnvSource);
        return envFromSource;
    }

    static class NestedCommaDelimitedVariableParser {
        static final String REGEX = "(\\w+='.+?'),?";
        static final Pattern pattern = Pattern.compile("(\\w+='.+?'),?");

        NestedCommaDelimitedVariableParser() {
        }

        String[] parse(String value) {
            ArrayList<String> vars = new ArrayList<String>();
            Matcher m = pattern.matcher(value);
            while (m.find()) {
                String replacedVar = m.group(1).replaceAll("'", "");
                if (!StringUtils.hasText((String)replacedVar)) continue;
                vars.add(replacedVar);
            }
            String nonQuotedVars = value.replaceAll(pattern.pattern(), "");
            if (StringUtils.hasText((String)nonQuotedVars)) {
                vars.addAll(Arrays.asList(nonQuotedVars.split(",")));
            }
            return vars.toArray(new String[0]);
        }
    }
}

