/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.TcpProbeCreator;
import org.springframework.util.StringUtils;

class ReadinessTcpProbeCreator
extends TcpProbeCreator {
    ReadinessTcpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Tcp", "ProbeDelay", this.getKubernetesDeployerProperties().getReadinessTcpProbeDelay());
    }

    @Override
    int getPeriod() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Tcp", "ProbePeriod", this.getKubernetesDeployerProperties().getReadinessTcpProbePeriod());
    }

    @Override
    protected int getTimeout() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Tcp", "ProbeTimeout", this.getKubernetesDeployerProperties().getReadinessTcpProbeTimeout());
    }

    @Override
    Integer getPort() {
        String probePortValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.readiness", "Tcp", "ProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            if (!probePortValue.chars().allMatch(Character::isDigit)) {
                throw new IllegalArgumentException("ReadinessTcpProbePort must contain all digits");
            }
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getReadinessTcpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getReadinessTcpProbePort();
        }
        throw new IllegalArgumentException("A readinessTcpProbePort property must be set.");
    }

    @Override
    int getFailure() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Tcp", "ProbeFailure", this.getKubernetesDeployerProperties().getReadinessTcpProbeFailure());
    }

    @Override
    int getSuccess() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Tcp", "ProbeSuccess", this.getKubernetesDeployerProperties().getReadinessTcpProbeSuccess());
    }
}

