/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.CommandProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.util.CommandLineTokenizer;
import org.springframework.util.StringUtils;

class ReadinessCommandProbeCreator
extends CommandProbeCreator {
    ReadinessCommandProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        String probeDelayValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.readinessCommandProbeDelay");
        if (StringUtils.hasText((String)probeDelayValue)) {
            return Integer.valueOf(probeDelayValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessCommandProbeDelay();
    }

    @Override
    int getPeriod() {
        String probePeriodValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.readinessCommandProbePeriod");
        if (StringUtils.hasText((String)probePeriodValue)) {
            return Integer.valueOf(probePeriodValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessCommandProbePeriod();
    }

    @Override
    String[] getCommand() {
        String probeCommandValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.readinessCommandProbeCommand");
        if (StringUtils.hasText((String)probeCommandValue)) {
            return new CommandLineTokenizer(probeCommandValue).getArgs().toArray(new String[0]);
        }
        if (this.getKubernetesDeployerProperties().getReadinessCommandProbeCommand() != null) {
            return new CommandLineTokenizer(this.getKubernetesDeployerProperties().getReadinessCommandProbeCommand()).getArgs().toArray(new String[0]);
        }
        throw new IllegalArgumentException("The readinessCommandProbeCommand property must be set.");
    }
}

