/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.HttpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.util.StringUtils;

class ReadinessHttpProbeCreator
extends HttpProbeCreator {
    ReadinessHttpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    public Integer getPort() {
        String probePortValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.readiness", "ProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            if (!probePortValue.chars().allMatch(Character::isDigit)) {
                throw new IllegalArgumentException("ReadinessHttpProbeCreator must contain all digits");
            }
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getReadinessHttpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getReadinessHttpProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.readiness", "ProbePath");
        if (StringUtils.hasText((String)probePathValue)) {
            return probePathValue;
        }
        if (this.getKubernetesDeployerProperties().getReadinessHttpProbePath() != null) {
            return this.getKubernetesDeployerProperties().getReadinessHttpProbePath();
        }
        if (this.useBoot1ProbePath()) {
            return "/info";
        }
        return "/actuator/info";
    }

    @Override
    protected int getTimeout() {
        String probeTimeoutValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.readiness", "ProbeTimeout");
        if (StringUtils.hasText((String)probeTimeoutValue)) {
            return Integer.valueOf(probeTimeoutValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessHttpProbeTimeout();
    }

    @Override
    protected int getInitialDelay() {
        String probeDelayValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.readiness", "ProbeDelay");
        if (StringUtils.hasText((String)probeDelayValue)) {
            return Integer.valueOf(probeDelayValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessHttpProbeDelay();
    }

    @Override
    protected int getPeriod() {
        String probePeriodValue = this.getProbePropertyName("spring.cloud.deployer.kubernetes.readiness", "ProbePeriod");
        if (StringUtils.hasText((String)probePeriodValue)) {
            return Integer.valueOf(probePeriodValue);
        }
        return this.getKubernetesDeployerProperties().getReadinessHttpProbePeriod();
    }
}

