/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes.support;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.deployer.spi.kubernetes.support.RelaxedNames;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertyParserUtils {
    public static Map<String, String> getStringPairsToMap(String stringPairs) {
        HashMap<String, String> mapValue = new HashMap<String, String>();
        if (StringUtils.hasText((String)stringPairs)) {
            String[] pairs;
            for (String pair : pairs = stringPairs.split(",")) {
                String[] splitString = pair.split(":", 2);
                Assert.isTrue((splitString.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid annotation value: %s", pair));
                mapValue.put(splitString[0].trim(), splitString[1].trim());
            }
        }
        return mapValue;
    }

    public static String getDeploymentPropertyValue(Map<String, String> deploymentProperties, String propertyName) {
        return PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, propertyName, null);
    }

    public static String getDeploymentPropertyValue(Map<String, String> deploymentProperties, String propertyName, String defaultValue) {
        RelaxedNames relaxedNames = new RelaxedNames(propertyName);
        for (String relaxedName : relaxedNames) {
            if (!deploymentProperties.containsKey(relaxedName)) continue;
            return deploymentProperties.get(relaxedName);
        }
        return defaultValue;
    }
}

