/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeCreator;
import org.springframework.util.StringUtils;

class LivenessProbeCreator
extends ProbeCreator {
    private static final String PROBE_PROPERTY_PREFIX = "spring.cloud.deployer.kubernetes.liveness";

    public LivenessProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    public Integer getPort() {
        String probePortKey = "spring.cloud.deployer.kubernetes.livenessProbePort";
        String probePortValue = this.getDeploymentPropertyValue(probePortKey);
        if (StringUtils.hasText((String)probePortValue)) {
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getLivenessProbePort() != null) {
            return this.getKubernetesDeployerProperties().getLivenessProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathKey = "spring.cloud.deployer.kubernetes.livenessProbePath";
        String probePathValue = this.getDeploymentPropertyValue(probePathKey);
        if (StringUtils.hasText((String)probePathValue)) {
            return probePathValue;
        }
        if (this.getKubernetesDeployerProperties().getLivenessProbePath() != null) {
            return this.getKubernetesDeployerProperties().getLivenessProbePath();
        }
        if (this.useBoot1ProbePath()) {
            return "/health";
        }
        return "/actuator/health";
    }

    @Override
    protected int getTimeout() {
        String probeTimeoutKey = "spring.cloud.deployer.kubernetes.livenessProbeTimeout";
        String probeTimeoutValue = this.getDeploymentPropertyValue(probeTimeoutKey);
        if (StringUtils.hasText((String)probeTimeoutValue)) {
            return Integer.valueOf(probeTimeoutValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessProbeTimeout();
    }

    @Override
    protected int getInitialDelay() {
        String probeDelayKey = "spring.cloud.deployer.kubernetes.livenessProbeDelay";
        String probeDelayValue = this.getDeploymentPropertyValue(probeDelayKey);
        if (StringUtils.hasText((String)probeDelayValue)) {
            return Integer.valueOf(probeDelayValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessProbeDelay();
    }

    @Override
    protected int getPeriod() {
        String probePeriodKey = "spring.cloud.deployer.kubernetes.livenessProbePeriod";
        String probePeriodValue = this.getDeploymentPropertyValue(probePeriodKey);
        if (StringUtils.hasText((String)probePeriodValue)) {
            return Integer.valueOf(probePeriodValue);
        }
        return this.getKubernetesDeployerProperties().getLivenessProbePeriod();
    }
}

