/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeCreator;

class ReadinessProbeCreator
extends ProbeCreator {
    private static final String PROBE_PROPERTY_PREFIX = "spring.cloud.deployer.kubernetes.readiness";

    public ReadinessProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    public Integer getPort() {
        String probePortKey = "spring.cloud.deployer.kubernetes.readinessProbePort";
        if (this.getDeploymentProperties().containsKey(probePortKey)) {
            return Integer.parseInt(this.getDeploymentProperties().get(probePortKey));
        }
        if (this.getKubernetesDeployerProperties().getReadinessProbePort() != null) {
            return this.getKubernetesDeployerProperties().getReadinessProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathKey = "spring.cloud.deployer.kubernetes.readinessProbePath";
        if (this.getDeploymentProperties().containsKey(probePathKey)) {
            return this.getDeploymentProperties().get(probePathKey);
        }
        if (this.getKubernetesDeployerProperties().getReadinessProbePath() != null) {
            return this.getKubernetesDeployerProperties().getReadinessProbePath();
        }
        if (this.useBoot1ProbePath()) {
            return "/info";
        }
        return "/actuator/info";
    }

    @Override
    protected int getTimeout() {
        String probeTimeoutKey = "spring.cloud.deployer.kubernetes.readinessProbeTimeout";
        if (this.getDeploymentProperties().containsKey(probeTimeoutKey)) {
            return Integer.valueOf(this.getDeploymentProperties().get(probeTimeoutKey));
        }
        return this.getKubernetesDeployerProperties().getReadinessProbeTimeout();
    }

    @Override
    protected int getInitialDelay() {
        String probeDelayKey = "spring.cloud.deployer.kubernetes.readinessProbeDelay";
        if (this.getDeploymentProperties().containsKey(probeDelayKey)) {
            return Integer.valueOf(this.getDeploymentProperties().get(probeDelayKey));
        }
        return this.getKubernetesDeployerProperties().getReadinessProbeDelay();
    }

    @Override
    protected int getPeriod() {
        String probePeriodKey = "spring.cloud.deployer.kubernetes.readinessProbePeriod";
        if (this.getDeploymentProperties().containsKey(probePeriodKey)) {
            return Integer.valueOf(this.getDeploymentProperties().get(probePeriodKey));
        }
        return this.getKubernetesDeployerProperties().getReadinessProbePeriod();
    }
}

