/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.PropertyParserUtils;
import org.springframework.util.StringUtils;

public class KubernetesAppDeployer
extends AbstractKubernetesDeployer
implements AppDeployer {
    private static final String SERVER_PORT_KEY = "server.port";
    protected final Log logger = LogFactory.getLog((String)this.getClass().getName());

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client) {
        this(properties, client, new DefaultContainerFactory(properties));
    }

    @Autowired
    public KubernetesAppDeployer(KubernetesDeployerProperties properties, KubernetesClient client, ContainerFactory containerFactory) {
        this.properties = properties;
        this.client = client;
        this.containerFactory = containerFactory;
    }

    public String deploy(AppDeploymentRequest request) {
        String appId = this.createDeploymentId(request);
        this.logger.debug((Object)String.format("Deploying app: %s", appId));
        try {
            AppStatus status = this.status(appId);
            if (!status.getState().equals((Object)DeploymentState.unknown)) {
                throw new IllegalStateException(String.format("App '%s' is already deployed", appId));
            }
            int externalPort = this.configureExternalPort(request);
            String indexedProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.indexed");
            boolean indexed = indexedProperty != null ? Boolean.valueOf(indexedProperty) : false;
            Map<String, String> idMap = this.createIdMap(appId, request);
            if (indexed) {
                this.logger.debug((Object)String.format("Creating Service: %s on %d with", appId, externalPort));
                this.createService(appId, request, idMap, externalPort);
                this.logger.debug((Object)String.format("Creating StatefulSet: %s", appId));
                this.createStatefulSet(appId, request, idMap, externalPort);
            } else {
                this.logger.debug((Object)String.format("Creating Service: %s on %d", appId, externalPort));
                this.createService(appId, request, idMap, externalPort);
                this.logger.debug((Object)String.format("Creating Deployment: %s", appId));
                this.createDeployment(appId, request, idMap, externalPort);
            }
            return appId;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void undeploy(String appId) {
        this.logger.debug((Object)String.format("Undeploying app: %s", appId));
        AppStatus status = this.status(appId);
        if (status.getState().equals((Object)DeploymentState.unknown)) {
            throw new IllegalStateException(String.format("App '%s' is not deployed", appId));
        }
        List apps = ((ServiceList)((FilterWatchListDeletable)this.client.services().withLabel("spring-app-id", appId)).list()).getItems();
        if (apps != null) {
            for (Service app : apps) {
                String appIdToDelete = app.getMetadata().getName();
                this.logger.debug((Object)String.format("Deleting Resources for: %s", appIdToDelete));
                Service svc = (Service)((ServiceResource)this.client.services().withName(appIdToDelete)).get();
                try {
                    if (svc != null && "LoadBalancer".equals(svc.getSpec().getType())) {
                        int tries = 0;
                        int maxWait = this.properties.getMinutesToWaitForLoadBalancer() * 6;
                        while (tries++ < maxWait && svc.getStatus() != null && svc.getStatus().getLoadBalancer() != null && svc.getStatus().getLoadBalancer().getIngress() != null && svc.getStatus().getLoadBalancer().getIngress().isEmpty()) {
                            if (tries % 6 == 0) {
                                this.logger.warn((Object)"Waiting for LoadBalancer to complete before deleting it ...");
                            }
                            this.logger.debug((Object)String.format("Waiting for LoadBalancer, try %d", tries));
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            svc = (Service)((ServiceResource)this.client.services().withName(appIdToDelete)).get();
                        }
                        this.logger.debug((Object)String.format("LoadBalancer Ingress: %s", svc.getStatus().getLoadBalancer().getIngress().toString()));
                    }
                    this.deleteAllObjects(appIdToDelete);
                }
                catch (RuntimeException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public AppStatus status(String appId) {
        HashMap<String, String> selector = new HashMap<String, String>();
        ServiceList services = (ServiceList)((FilterWatchListDeletable)this.client.services().withLabel("spring-app-id", appId)).list();
        selector.put("spring-app-id", appId);
        PodList podList = (PodList)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).list();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Building AppStatus for app: %s", appId));
            if (podList != null && podList.getItems() != null) {
                this.logger.debug((Object)String.format("Pods for appId %s: %d", appId, podList.getItems().size()));
                for (Pod pod : podList.getItems()) {
                    this.logger.debug((Object)String.format("Pod: %s", pod.getMetadata().getName()));
                }
            }
        }
        AppStatus status = this.buildAppStatus(appId, podList, services);
        this.logger.debug((Object)String.format("Status for app: %s is %s", appId, status));
        return status;
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return super.createRuntimeEnvironmentInfo(AppDeployer.class, this.getClass());
    }

    protected int configureExternalPort(AppDeploymentRequest request) {
        int externalPort = 8080;
        Map parameters = request.getDefinition().getProperties();
        if (parameters.containsKey(SERVER_PORT_KEY)) {
            externalPort = Integer.valueOf((String)parameters.get(SERVER_PORT_KEY));
        }
        return externalPort;
    }

    protected String createDeploymentId(AppDeploymentRequest request) {
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        String deploymentId = groupId == null ? String.format("%s", request.getDefinition().getName()) : String.format("%s-%s", groupId, request.getDefinition().getName());
        return deploymentId.replace('.', '-').toLowerCase();
    }

    private Deployment createDeployment(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        int replicas = this.getCountFromRequest(request);
        Map<String, String> annotations = this.getPodAnnotations(request);
        PodSpec podSpec = this.createPodSpec(appId, request, externalPort, false);
        Deployment d = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withNewSpec().withNewSelector().addToMatchLabels(idMap)).endSelector()).withReplicas(Integer.valueOf(replicas))).withNewTemplate().withNewMetadata().withLabels(idMap)).addToLabels("role", "spring-app")).withAnnotations(annotations)).endMetadata()).withSpec(podSpec)).endTemplate()).endSpec()).build();
        return (Deployment)this.client.apps().deployments().create((Object[])new Deployment[]{d});
    }

    private int getCountFromRequest(AppDeploymentRequest request) {
        String countProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.count");
        return countProperty != null ? Integer.parseInt(countProperty) : 1;
    }

    protected void createStatefulSet(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        int replicas = this.getCountFromRequest(request);
        this.logger.debug((Object)String.format("Creating StatefulSet: %s on %d with %d replicas", appId, externalPort, replicas));
        Map<String, Quantity> storageResource = Collections.singletonMap("storage", new Quantity(this.getStatefulSetStorage(request)));
        String storageClassName = this.getStatefulSetStorageClassName(request);
        PersistentVolumeClaimBuilder persistentVolumeClaimBuilder = (PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)new PersistentVolumeClaimBuilder().withNewSpec().withStorageClassName(storageClassName)).withAccessModes(Collections.singletonList("ReadWriteOnce"))).withNewResources().addToLimits(storageResource)).addToRequests(storageResource)).endResources()).endSpec()).withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata();
        PodSpec podSpec = this.createPodSpec(appId, request, externalPort, false);
        podSpec.getVolumes().add(((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("config")).withNewEmptyDir().endEmptyDir()).build());
        ((Container)podSpec.getContainers().get(0)).getVolumeMounts().add(((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("config")).withMountPath("/config")).build());
        podSpec.getInitContainers().add(this.createInitContainer());
        StatefulSetSpec spec = ((StatefulSetSpecBuilder)((StatefulSetSpecFluent.TemplateNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecFluent.SelectorNested)((StatefulSetSpecFluent.SelectorNested)new StatefulSetSpecBuilder().withNewSelector().addToMatchLabels(idMap)).addToMatchLabels("role", "spring-app")).endSelector()).withVolumeClaimTemplates(new PersistentVolumeClaim[]{persistentVolumeClaimBuilder.build()})).withServiceName(appId)).withPodManagementPolicy("Parallel")).withReplicas(Integer.valueOf(replicas))).withNewTemplate().withNewMetadata().withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withSpec(podSpec)).endTemplate()).build();
        StatefulSet statefulSet = ((StatefulSetBuilder)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)new StatefulSetBuilder().withNewMetadata().withName(appId)).withLabels(idMap)).addToLabels("role", "spring-app")).endMetadata()).withSpec(spec)).build();
        this.client.apps().statefulSets().create((Object[])new StatefulSet[]{statefulSet});
    }

    protected void createService(String appId, AppDeploymentRequest request, Map<String, String> idMap, int externalPort) {
        ServiceSpecBuilder spec = new ServiceSpecBuilder();
        boolean isCreateLoadBalancer = false;
        String createLoadBalancer = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.createLoadBalancer");
        String createNodePort = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.createNodePort");
        if (createLoadBalancer != null && createNodePort != null) {
            throw new IllegalArgumentException("Cannot create NodePort and LoadBalancer at the same time.");
        }
        if (createLoadBalancer == null) {
            isCreateLoadBalancer = this.properties.isCreateLoadBalancer();
        } else if ("true".equals(createLoadBalancer.toLowerCase())) {
            isCreateLoadBalancer = true;
        }
        if (isCreateLoadBalancer) {
            spec.withType("LoadBalancer");
        }
        ServicePort servicePort = new ServicePort();
        servicePort.setPort(Integer.valueOf(externalPort));
        if (createNodePort != null) {
            spec.withType("NodePort");
            if (!"true".equals(createNodePort.toLowerCase())) {
                try {
                    Integer nodePort = Integer.valueOf(createNodePort);
                    servicePort.setNodePort(nodePort);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid value: %s: provided port is not valid.", createNodePort));
                }
            }
        }
        ((ServiceSpecBuilder)spec.withSelector(idMap)).addNewPortLike(servicePort).endPort();
        Map<String, String> annotations = this.getServiceAnnotations(request);
        ((DoneableService)((DoneableService)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((DoneableService)this.client.services().createNew()).withNewMetadata().withName(appId)).withLabels(idMap)).withAnnotations(annotations)).addToLabels("role", "spring-app")).endMetadata()).withSpec(spec.build())).done();
    }

    private Map<String, String> getPodAnnotations(AppDeploymentRequest request) {
        String annotationsProperty = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.podAnnotations", "");
        if (StringUtils.isEmpty((Object)annotationsProperty)) {
            annotationsProperty = this.properties.getPodAnnotations();
        }
        return PropertyParserUtils.getAnnotations(annotationsProperty);
    }

    private Map<String, String> getServiceAnnotations(AppDeploymentRequest request) {
        String annotationsProperty = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.serviceAnnotations", "");
        if (StringUtils.isEmpty((Object)annotationsProperty)) {
            annotationsProperty = this.properties.getServiceAnnotations();
        }
        return PropertyParserUtils.getAnnotations(annotationsProperty);
    }

    private Container createInitContainer() {
        LinkedList<String> command = new LinkedList<String>();
        String commandString = String.format("%s && %s", this.setIndexProperty("INSTANCE_INDEX"), this.setIndexProperty("spring.application.index"));
        command.add("sh");
        command.add("-c");
        command.add(commandString);
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("index-provider")).withImage("busybox")).withImagePullPolicy("IfNotPresent")).withCommand(command)).withVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("config")).withMountPath("/config")).build()})).build();
    }

    private String setIndexProperty(String name) {
        return String.format("echo %s=\"$(expr $HOSTNAME | grep -o \"[[:digit:]]*$\")\" >> /config/application.properties", name);
    }

    private void deleteAllObjects(String appIdToDelete) {
        Map<String, String> labels = Collections.singletonMap("spring-app-id", appIdToDelete);
        this.deleteService(labels);
        this.deleteReplicationController(labels);
        this.deleteDeployment(labels);
        this.deleteStatefulSet(labels);
        this.deletePod(labels);
        this.deletePvc(labels);
    }

    private void deleteService(Map<String, String> labels) {
        FilterWatchListDeletable servicesToDelete = (FilterWatchListDeletable)this.client.services().withLabels(labels);
        if (servicesToDelete != null && ((ServiceList)servicesToDelete.list()).getItems() != null) {
            boolean servicesDeleted = (Boolean)servicesToDelete.delete();
            this.logger.debug((Object)String.format("Service deleted for: %s - %b", labels, servicesDeleted));
        }
    }

    private void deleteReplicationController(Map<String, String> labels) {
        FilterWatchListDeletable replicationControllersToDelete = (FilterWatchListDeletable)this.client.replicationControllers().withLabels(labels);
        if (replicationControllersToDelete != null && ((ReplicationControllerList)replicationControllersToDelete.list()).getItems() != null) {
            boolean replicationControllersDeleted = (Boolean)replicationControllersToDelete.delete();
            this.logger.debug((Object)String.format("ReplicationController deleted for: %s - %b", labels, replicationControllersDeleted));
        }
    }

    private void deleteDeployment(Map<String, String> labels) {
        FilterWatchListDeletable deploymentsToDelete = (FilterWatchListDeletable)this.client.apps().deployments().withLabels(labels);
        if (deploymentsToDelete != null && ((DeploymentList)deploymentsToDelete.list()).getItems() != null) {
            boolean deploymentsDeleted = (Boolean)deploymentsToDelete.delete();
            this.logger.debug((Object)String.format("Deployment deleted for: %s - %b", labels, deploymentsDeleted));
        }
    }

    private void deleteStatefulSet(Map<String, String> labels) {
        FilterWatchListDeletable ssToDelete = (FilterWatchListDeletable)this.client.apps().statefulSets().withLabels(labels);
        if (ssToDelete != null && ((StatefulSetList)ssToDelete.list()).getItems() != null) {
            boolean ssDeleted = (Boolean)ssToDelete.delete();
            this.logger.debug((Object)String.format("StatefulSet deleted for: %s - %b", labels, ssDeleted));
        }
    }

    private void deletePod(Map<String, String> labels) {
        FilterWatchListDeletable podsToDelete = (FilterWatchListDeletable)this.client.pods().withLabels(labels);
        if (podsToDelete != null && ((PodList)podsToDelete.list()).getItems() != null) {
            boolean podsDeleted = (Boolean)podsToDelete.delete();
            this.logger.debug((Object)String.format("Pod deleted for: %s - %b", labels, podsDeleted));
        }
    }

    private void deletePvc(Map<String, String> labels) {
        FilterWatchListDeletable pvcsToDelete = (FilterWatchListDeletable)this.client.persistentVolumeClaims().withLabels(labels);
        if (pvcsToDelete != null && ((PersistentVolumeClaimList)pvcsToDelete.list()).getItems() != null) {
            boolean pvcsDeleted = (Boolean)pvcsToDelete.delete();
            this.logger.debug((Object)String.format("PVC deleted for: %s - %b", labels, pvcsDeleted));
        }
    }
}

