/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KubernetesHttpClient {
    private static final Log logger = LogFactory.getLog(KubernetesHttpClient.class);
    private final OkHttpClient client;
    private final String masterUrl;

    KubernetesHttpClient(KubernetesClient client) {
        this.client = ((BaseClient)client).getHttpClient();
        this.masterUrl = client.getMasterUrl().toString();
    }

    public Response post(String resourceEndpoint, String json) {
        String url = this.masterUrl + resourceEndpoint;
        logger.debug((Object)("Posting to " + url));
        Request post = new Request.Builder().post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json)).url(url).build();
        Response response = this.execute(this.client.newCall(post));
        response.close();
        return response;
    }

    public Response get(String resourceEndpoint, String appId) {
        String url = this.masterUrl + resourceEndpoint + "/" + appId;
        logger.debug((Object)("Getting " + url));
        Request get = new Request.Builder().get().url(url).build();
        return this.execute(this.client.newCall(get));
    }

    public Response delete(String resourceEndpoint, String appId) {
        String url = this.masterUrl + resourceEndpoint + "/" + appId;
        logger.debug((Object)("Deleting " + url));
        Request delete = new Request.Builder().delete().url(url).build();
        Response response = this.execute(this.client.newCall(delete));
        response.close();
        return response;
    }

    private Response execute(Call call) {
        Response response;
        try {
            response = call.execute();
            logger.debug((Object)("Response code: " + response.code()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }
}

