/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.util.Assert;

public class DefaultContainerFactory
implements ContainerFactory {
    private static Logger logger = LoggerFactory.getLogger(DefaultContainerFactory.class);
    private static final String LIVENESS_ENDPOINT = "/health";
    private static final String READINESS_ENDPOINT = "/info";
    private final KubernetesDeployerProperties properties;

    public DefaultContainerFactory(KubernetesDeployerProperties properties) {
        this.properties = properties;
    }

    @Override
    public Container create(String appId, AppDeploymentRequest request, Integer port) {
        ContainerBuilder container = new ContainerBuilder();
        String image = null;
        try {
            image = request.getResource().getURI().getSchemeSpecificPart();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get URI for " + request.getResource(), e);
        }
        logger.info("Using Docker image: " + image);
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        for (String envVar : this.properties.getEnvironmentVariables()) {
            String[] strings = envVar.split("=", 2);
            Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
            envVars.add(new EnvVar(strings[0], strings[1], null));
        }
        ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)container.withName(appId)).withImage(image)).withEnv(envVars)).withArgs(this.createCommandArgs(request));
        if (port != null) {
            ((ContainerBuilder)((ContainerBuilder)((ContainerFluent.PortsNested)container.addNewPort().withContainerPort(port)).endPort()).withReadinessProbe(this.createProbe(port, READINESS_ENDPOINT, this.properties.getReadinessProbeTimeout(), this.properties.getReadinessProbeDelay(), this.properties.getReadinessProbePeriod()))).withLivenessProbe(this.createProbe(port, LIVENESS_ENDPOINT, this.properties.getLivenessProbeTimeout(), this.properties.getLivenessProbeDelay(), this.properties.getLivenessProbePeriod()));
        }
        return container.build();
    }

    protected Probe createProbe(Integer externalPort, String endpoint, int timeout, int initialDelay, int period) {
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withHttpGet((HTTPGetAction)((HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath(endpoint)).withNewPort(externalPort)).build())).withTimeoutSeconds(Integer.valueOf(timeout))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).withPeriodSeconds(Integer.valueOf(period))).build();
    }

    protected List<String> createCommandArgs(AppDeploymentRequest request) {
        LinkedList<String> cmdArgs = new LinkedList<String>();
        Map args = request.getDefinition().getProperties();
        for (Map.Entry entry : args.entrySet()) {
            cmdArgs.add(String.format("--%s=%s", entry.getKey(), entry.getValue()));
        }
        cmdArgs.addAll(request.getCommandlineArguments());
        logger.debug("Using command args: " + cmdArgs);
        return cmdArgs;
    }
}

