/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.util.Optional;
import org.springframework.cloud.deployer.spi.app.AbstractActuatorTemplate;
import org.springframework.cloud.deployer.spi.app.AppAdmin;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.http.HttpHeaders;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CloudFoundryActuatorTemplate
extends AbstractActuatorTemplate {
    public CloudFoundryActuatorTemplate(RestTemplate restTemplate, AppDeployer appDeployer, AppAdmin appAdmin) {
        super(restTemplate, appDeployer, appAdmin);
    }

    protected String actuatorUrlForInstance(AppInstanceStatus appInstanceStatus) {
        return UriComponentsBuilder.fromHttpUrl((String)((String)appInstanceStatus.getAttributes().get("url"))).path("/actuator").toUriString();
    }

    public Optional<HttpHeaders> httpHeadersForInstance(AppInstanceStatus appInstanceStatus) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Cf-App-Instance", String.format("%s:%d", appInstanceStatus.getAttributes().get("cf-guid"), Integer.valueOf((String)appInstanceStatus.getAttributes().get("index"))));
        return Optional.of(headers);
    }
}

