/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.scheduler.cloudfoundry;

import io.jsonwebtoken.lang.Assert;
import io.pivotal.scheduler.SchedulerClient;
import io.pivotal.scheduler.v1.jobs.CreateJobRequest;
import io.pivotal.scheduler.v1.jobs.DeleteJobRequest;
import io.pivotal.scheduler.v1.jobs.Job;
import io.pivotal.scheduler.v1.jobs.JobSchedule;
import io.pivotal.scheduler.v1.jobs.ListJobsRequest;
import io.pivotal.scheduler.v1.jobs.ListJobsResponse;
import io.pivotal.scheduler.v1.jobs.ScheduleJobRequest;
import io.pivotal.scheduler.v1.jobs.ScheduleJobResponse;
import io.pivotal.scheduler.v1.schedules.ExpressionType;
import java.text.ParseException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.client.v2.applications.SummaryApplicationResponse;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.AbstractApplicationSummary;
import org.cloudfoundry.operations.applications.ApplicationSummary;
import org.cloudfoundry.operations.spaces.SpaceSummary;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryTaskLauncher;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.scheduler.CreateScheduleException;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleInfo;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.cloud.deployer.spi.scheduler.Scheduler;
import org.springframework.cloud.deployer.spi.scheduler.SchedulerException;
import org.springframework.cloud.deployer.spi.scheduler.UnScheduleException;
import org.springframework.cloud.deployer.spi.scheduler.cloudfoundry.CloudFoundryScheduleSSLException;
import org.springframework.cloud.deployer.spi.scheduler.cloudfoundry.CloudFoundrySchedulerProperties;
import org.springframework.cloud.deployer.spi.scheduler.cloudfoundry.expression.QuartzCronExpression;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CloudFoundryAppScheduler
implements Scheduler {
    public static final String CRON_EXPRESSION_KEY = "spring.cloud.deployer.cloudfoundry.cron.expression";
    private static final int PCF_PAGE_START_NUM = 1;
    private static final int MAX_SCHEDULE_NAME_LENGTH = 255;
    private static final String SCHEDULER_SERVICE_ERROR_MESSAGE = "Scheduler Service returned a null response.";
    protected static final Log logger = LogFactory.getLog(CloudFoundryAppScheduler.class);
    private final SchedulerClient client;
    private final CloudFoundryOperations operations;
    private final CloudFoundryConnectionProperties properties;
    private final CloudFoundryTaskLauncher taskLauncher;
    private final CloudFoundrySchedulerProperties schedulerProperties;
    private final CloudFoundryDeploymentProperties deploymentProperties;

    @Deprecated
    public CloudFoundryAppScheduler(SchedulerClient client, CloudFoundryOperations operations, CloudFoundryConnectionProperties properties, CloudFoundryTaskLauncher taskLauncher, CloudFoundrySchedulerProperties schedulerProperties) {
        Assert.notNull((Object)client, (String)"client must not be null");
        Assert.notNull((Object)operations, (String)"operations must not be null");
        Assert.notNull((Object)properties, (String)"properties must not be null");
        Assert.notNull((Object)taskLauncher, (String)"taskLauncher must not be null");
        Assert.notNull((Object)schedulerProperties, (String)"schedulerProperties must not be null");
        this.client = client;
        this.operations = operations;
        this.properties = properties;
        this.taskLauncher = taskLauncher;
        this.schedulerProperties = schedulerProperties;
        this.deploymentProperties = new CloudFoundryDeploymentProperties();
        this.deploymentProperties.setSchedulerUrl(this.schedulerProperties.getSchedulerUrl());
        this.deploymentProperties.setScheduleSSLRetryCount(this.schedulerProperties.getScheduleSSLRetryCount());
        this.deploymentProperties.setScheduleTimeoutInSeconds(this.schedulerProperties.getScheduleTimeoutInSeconds());
        this.deploymentProperties.setUnScheduleTimeoutInSeconds(this.schedulerProperties.getScheduleTimeoutInSeconds());
        this.deploymentProperties.setListTimeoutInSeconds(this.schedulerProperties.getListTimeoutInSeconds());
    }

    public CloudFoundryAppScheduler(SchedulerClient client, CloudFoundryOperations operations, CloudFoundryConnectionProperties properties, CloudFoundryTaskLauncher taskLauncher, CloudFoundryDeploymentProperties deploymentProperties) {
        Assert.notNull((Object)client, (String)"client must not be null");
        Assert.notNull((Object)operations, (String)"operations must not be null");
        Assert.notNull((Object)properties, (String)"properties must not be null");
        Assert.notNull((Object)taskLauncher, (String)"taskLauncher must not be null");
        Assert.notNull((Object)deploymentProperties, (String)"deployment must not be null");
        this.client = client;
        this.operations = operations;
        this.properties = properties;
        this.taskLauncher = taskLauncher;
        this.deploymentProperties = deploymentProperties;
        this.schedulerProperties = null;
    }

    public void schedule(ScheduleRequest scheduleRequest) {
        final String appName = scheduleRequest.getDefinition().getName();
        final String scheduleName = scheduleRequest.getScheduleName();
        logger.debug((Object)String.format("Scheduling: %s", scheduleName));
        if (scheduleName.length() > 255) {
            throw new CreateScheduleException(String.format("Schedule can not be created because its name '%s' has too many characters.  Schedule name length must be %s characters or less.", scheduleName, 255), null);
        }
        String cronExpressionCandidate = null;
        if (cronExpressionCandidate == null && scheduleRequest.getSchedulerProperties() != null) {
            cronExpressionCandidate = (String)scheduleRequest.getSchedulerProperties().get("spring.cloud.scheduler.cron.expression");
        } else if (cronExpressionCandidate == null && scheduleRequest.getDeploymentProperties().get("spring.cloud.scheduler.cron.expression") != null) {
            cronExpressionCandidate = (String)scheduleRequest.getDeploymentProperties().get("spring.cloud.scheduler.cron.expression");
        } else if (cronExpressionCandidate == null && scheduleRequest.getDeploymentProperties().get("spring.cloud.deployer.cron.expression") != null) {
            cronExpressionCandidate = (String)scheduleRequest.getDeploymentProperties().get("spring.cloud.deployer.cron.expression");
        } else if (scheduleRequest.getDeploymentProperties().get(CRON_EXPRESSION_KEY) != null) {
            cronExpressionCandidate = (String)scheduleRequest.getDeploymentProperties().get(CRON_EXPRESSION_KEY);
        }
        Assert.hasText((String)cronExpressionCandidate, (String)String.format("request's scheduleProperties must have a %s or %s that is not null nor empty", "spring.cloud.scheduler.cron.expression", CRON_EXPRESSION_KEY));
        final String cronExpression = cronExpressionCandidate;
        try {
            new QuartzCronExpression("0 " + cronExpression);
        }
        catch (ParseException pe) {
            throw new CreateScheduleException("Cron Expression is invalid: " + pe.getMessage(), (Throwable)pe);
        }
        final String command = this.stageTask(scheduleRequest);
        this.retryTemplate().execute((RetryCallback)new RetryCallback<Void, RuntimeException>(){

            public Void doWithRetry(RetryContext retryContext) throws RuntimeException {
                CloudFoundryAppScheduler.this.scheduleTask(appName, scheduleName, cronExpression, command);
                return null;
            }
        }, (RecoveryCallback)new RecoveryCallback<Void>(){

            public Void recover(RetryContext retryContext) throws Exception {
                if (retryContext.getLastThrowable() != null) {
                    logger.error((Object)("Retry Context reported the following exception: " + retryContext.getLastThrowable().getMessage()));
                }
                logger.error((Object)"Unable to schedule application");
                try {
                    logger.debug((Object)"removing job portion of the schedule.");
                    CloudFoundryAppScheduler.this.unschedule(scheduleName);
                }
                catch (UnScheduleException ex) {
                    logger.debug((Object)"No job to be removed.");
                }
                throw new CreateScheduleException(scheduleName, retryContext.getLastThrowable());
            }
        });
    }

    public void unschedule(String scheduleName) {
        logger.debug((Object)String.format("Unscheduling: %s", scheduleName));
        this.client.jobs().delete(DeleteJobRequest.builder().jobId(this.getJob(scheduleName)).build()).block(Duration.ofSeconds(this.deploymentProperties.getUnScheduleTimeoutInSeconds()));
    }

    public List<ScheduleInfo> list(String taskDefinitionName) {
        return this.list().stream().filter(scheduleInfo -> scheduleInfo.getTaskDefinitionName().equals(taskDefinitionName)).collect(Collectors.toList());
    }

    public List<ScheduleInfo> list() {
        ArrayList<ScheduleInfo> result = new ArrayList<ScheduleInfo>();
        for (int i = 1; i <= this.getJobPageCount(); ++i) {
            List scheduleInfoPage = (List)this.getSchedules(i).collectList().block(Duration.ofSeconds(this.deploymentProperties.getListTimeoutInSeconds()));
            if (scheduleInfoPage == null) {
                throw new SchedulerException(SCHEDULER_SERVICE_ERROR_MESSAGE);
            }
            result.addAll(scheduleInfoPage);
        }
        return result;
    }

    private void scheduleTask(String appName, String scheduleName, String expression, String command) {
        logger.debug((Object)String.format("Scheduling Task: ", appName));
        ScheduleJobResponse response = (ScheduleJobResponse)this.getApplicationByAppName(appName).flatMap(abstractApplicationSummary -> this.client.jobs().create(CreateJobRequest.builder().applicationId(abstractApplicationSummary.getId()).command(command).name(scheduleName).build())).flatMap(createJobResponse -> this.client.jobs().schedule(ScheduleJobRequest.builder().jobId(createJobResponse.getId()).expression(expression).expressionType(ExpressionType.CRON).enabled(Boolean.valueOf(true)).build())).onErrorMap(e -> {
            if (e instanceof SSLException) {
                throw new CloudFoundryScheduleSSLException("Failed to schedule" + scheduleName, (Throwable)e);
            }
            throw new CreateScheduleException(scheduleName, e);
        }).block(Duration.ofSeconds(this.deploymentProperties.getScheduleTimeoutInSeconds()));
        if (response == null) {
            throw new SchedulerException(SCHEDULER_SERVICE_ERROR_MESSAGE);
        }
    }

    private String stageTask(ScheduleRequest scheduleRequest) {
        logger.debug((Object)String.format("Staging Task: ", scheduleRequest.getDefinition().getName()));
        AppDeploymentRequest request = new AppDeploymentRequest(scheduleRequest.getDefinition(), scheduleRequest.getResource(), scheduleRequest.getDeploymentProperties(), scheduleRequest.getCommandlineArguments());
        SummaryApplicationResponse response = this.taskLauncher.stage(request);
        return this.taskLauncher.getCommand(response, request);
    }

    private Mono<AbstractApplicationSummary> getApplicationByAppName(String appName) {
        return this.requestListApplications().filter(application -> appName.equals(application.getName())).singleOrEmpty().cast(AbstractApplicationSummary.class);
    }

    private Flux<ApplicationSummary> requestListApplications() {
        return this.operations.applications().list();
    }

    private Flux<ApplicationSummary> cacheAppSummaries() {
        return this.requestListApplications().cache();
    }

    private Flux<SpaceSummary> requestSpaces() {
        return this.operations.spaces().list();
    }

    private Mono<SpaceSummary> getSpace(String spaceName) {
        return this.requestSpaces().cache().filter(space -> spaceName.equals(space.getName())).singleOrEmpty().cast(SpaceSummary.class);
    }

    private Mono<ApplicationSummary> getApplication(Flux<ApplicationSummary> applicationSummaries, String appId) {
        return applicationSummaries.filter(application -> appId.equals(application.getId())).singleOrEmpty();
    }

    private Flux<ScheduleInfo> getSchedules(int pageNumber) {
        Flux<ApplicationSummary> applicationSummaries = this.cacheAppSummaries();
        return this.getSpace(this.properties.getSpace()).flatMap(requestSummary -> this.client.jobs().list(ListJobsRequest.builder().spaceId(requestSummary.getId()).page(Integer.valueOf(pageNumber)).detailed(Boolean.valueOf(true)).build())).flatMapIterable(jobs -> jobs.getResources()).flatMap(job -> this.getApplication(applicationSummaries, job.getApplicationId()).map(optionalApp -> {
            ScheduleInfo scheduleInfo = new ScheduleInfo();
            scheduleInfo.setScheduleProperties(new HashMap());
            scheduleInfo.setScheduleName(job.getName());
            scheduleInfo.setTaskDefinitionName(optionalApp.getName());
            if (job.getJobSchedules() != null) {
                scheduleInfo.getScheduleProperties().put("spring.cloud.scheduler.cron.expression", ((JobSchedule)job.getJobSchedules().get(0)).getExpression());
            } else {
                logger.warn((Object)String.format("Job %s does not have an associated schedule", job.getName()));
            }
            return scheduleInfo;
        }));
    }

    private int getJobPageCount() {
        ListJobsResponse response = (ListJobsResponse)this.getSpace(this.properties.getSpace()).flatMap(requestSummary -> this.client.jobs().list(ListJobsRequest.builder().spaceId(requestSummary.getId()).detailed(Boolean.valueOf(false)).build())).block();
        if (response == null) {
            throw new SchedulerException(SCHEDULER_SERVICE_ERROR_MESSAGE);
        }
        return response.getPagination().getTotalPages();
    }

    private Mono<Job> getJobMono(String jobName, int page) {
        return this.getSpace(this.properties.getSpace()).flatMap(requestSummary -> this.client.jobs().list(ListJobsRequest.builder().spaceId(requestSummary.getId()).page(Integer.valueOf(page)).build())).flatMapIterable(jobs -> jobs.getResources()).filter(job -> job.getName().equals(jobName)).singleOrEmpty();
    }

    private String getJob(String jobName) {
        Job result = null;
        int pageCount = this.getJobPageCount();
        for (int pageNum = 1; pageNum <= pageCount && (result = (Job)this.getJobMono(jobName, pageNum).block()) == null; ++pageNum) {
        }
        if (result == null) {
            throw new UnScheduleException(String.format("schedule %s does not exist.", jobName));
        }
        return result.getId();
    }

    private RetryTemplate retryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(this.deploymentProperties.getScheduleSSLRetryCount(), Collections.singletonMap(CloudFoundryScheduleSSLException.class, true));
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        return retryTemplate;
    }
}

