/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.AbstractCloudFoundryException;
import org.cloudfoundry.UnknownCloudFoundryException;
import org.cloudfoundry.operations.services.BindServiceInstanceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.app.AppScaleRequest;
import org.springframework.cloud.deployer.spi.cloudfoundry.CfEnvAwareResource;
import org.springframework.cloud.deployer.spi.cloudfoundry.CfEnvConfigurer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.ServiceParser;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.retry.Retry;

class AbstractCloudFoundryDeployer {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final RuntimeEnvironmentInfo runtimeEnvironmentInfo;
    final CloudFoundryDeploymentProperties deploymentProperties;
    private final Logger logger = LoggerFactory.getLogger(AbstractCloudFoundryDeployer.class);

    AbstractCloudFoundryDeployer(CloudFoundryDeploymentProperties deploymentProperties, RuntimeEnvironmentInfo runtimeEnvironmentInfo) {
        this.deploymentProperties = deploymentProperties;
        this.runtimeEnvironmentInfo = runtimeEnvironmentInfo;
    }

    int memory(AppDeploymentRequest request) {
        String withUnit = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.memory", this.deploymentProperties.getMemory());
        return (int)ByteSizeUtils.parseToMebibytes((String)withUnit);
    }

    int memory(AppScaleRequest request) {
        if (request.getProperties().isPresent() && request.getProperties().get() != null) {
            return (int)ByteSizeUtils.parseToMebibytes((String)((Map)request.getProperties().get()).getOrDefault("spring.cloud.deployer.memory", this.deploymentProperties.getMemory()));
        }
        return (int)ByteSizeUtils.parseToMebibytes((String)this.deploymentProperties.getMemory());
    }

    int diskQuota(AppScaleRequest request) {
        if (request.getProperties().isPresent() && request.getProperties().get() != null) {
            return (int)ByteSizeUtils.parseToMebibytes((String)((Map)request.getProperties().get()).getOrDefault("spring.cloud.deployer.disk", this.deploymentProperties.getDisk()));
        }
        return (int)ByteSizeUtils.parseToMebibytes((String)this.deploymentProperties.getDisk());
    }

    Set<String> servicesToBind(AppDeploymentRequest request) {
        Set<String> services = this.deploymentProperties.getServices().stream().filter(s -> !ServiceParser.getServiceParameters(s).isPresent()).collect(Collectors.toSet());
        Set requestServices = ServiceParser.splitServiceProperties((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services")).stream().filter(s -> !ServiceParser.getServiceParameters(s).isPresent()).collect(Collectors.toSet());
        services.addAll(requestServices);
        return services;
    }

    boolean includesServiceParameters(AppDeploymentRequest request) {
        return this.deploymentProperties.getServices().stream().anyMatch(s -> ServiceParser.getServiceParameters(s).isPresent()) || ServiceParser.splitServiceProperties((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services")).stream().anyMatch(s -> ServiceParser.getServiceParameters(s).isPresent());
    }

    Stream<BindServiceInstanceRequest> bindParameterizedServiceInstanceRequests(AppDeploymentRequest request, String deploymentId) {
        return ServiceParser.splitServiceProperties((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services")).stream().filter(s -> ServiceParser.getServiceParameters(s).isPresent()).map(s -> BindServiceInstanceRequest.builder().applicationName(deploymentId).serviceInstanceName(ServiceParser.getServiceInstanceName(s)).parameters(ServiceParser.getServiceParameters(s).get()).build());
    }

    int diskQuota(AppDeploymentRequest request) {
        String withUnit = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.disk", this.deploymentProperties.getDisk());
        return (int)ByteSizeUtils.parseToMebibytes((String)withUnit);
    }

    Set<String> buildpacks(AppDeploymentRequest request) {
        String buidpacksValue = (String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.buildpacks");
        String buidpackValue = (String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.buildpack");
        if (buidpacksValue != null) {
            return StringUtils.commaDelimitedListToSet((String)buidpacksValue);
        }
        if (buidpackValue != null) {
            return new HashSet<String>(Arrays.asList(buidpackValue));
        }
        if (!ObjectUtils.isEmpty(this.deploymentProperties.getBuildpacks())) {
            return this.deploymentProperties.getBuildpacks();
        }
        return new HashSet<String>(Arrays.asList(this.deploymentProperties.getBuildpack()));
    }

    String javaOpts(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.javaOpts")).orElse(this.deploymentProperties.getJavaOpts());
    }

    Predicate<Throwable> isNotFoundError() {
        return t -> t instanceof AbstractCloudFoundryException && ((AbstractCloudFoundryException)t).getStatusCode() == HttpStatus.NOT_FOUND.value();
    }

    String getDockerImage(AppDeploymentRequest request) {
        try {
            String uri = request.getResource().getURI().toString();
            if (uri.startsWith("docker:")) {
                return uri.substring("docker:".length());
            }
            return null;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    Path getApplication(AppDeploymentRequest request) {
        try {
            this.logger.info("Preparing to push an application from {}. This may take some time if the artifact must be downloaded from a remote host.", (Object)request.getResource());
            if (!request.getResource().getURI().toString().startsWith("docker:")) {
                return request.getResource().getFile().toPath();
            }
            return null;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected Consumer<Throwable> logError(String msg) {
        return e -> {
            if (e instanceof UnknownCloudFoundryException) {
                this.logger.error(msg + "\nUnknownCloudFoundryException encountered, whose payload follows:\n" + ((UnknownCloudFoundryException)e).getPayload(), e);
            } else {
                this.logger.error(msg, e);
            }
        };
    }

    <T> Function<Mono<T>, Mono<T>> statusRetry(String id) {
        long statusTimeout = this.deploymentProperties.getStatusTimeout();
        long requestTimeout = Math.round((double)statusTimeout * 0.4);
        long initialRetryDelay = Math.round((double)statusTimeout * 0.1);
        if (requestTimeout < 500L) {
            this.logger.info("Computed statusRetry Request timeout = {} ms is below 500ms minimum value.  Setting to 500ms", (Object)requestTimeout);
            requestTimeout = 500L;
        }
        long requestTimeoutToUse = requestTimeout;
        return m -> m.timeout(Duration.ofMillis(requestTimeoutToUse)).doOnError(e -> {
            if (e instanceof TimeoutException) {
                this.logger.warn("Error getting status for {} within {}ms, Retrying operation.", (Object)id, (Object)requestTimeoutToUse);
            } else if (e instanceof UnknownCloudFoundryException) {
                this.logger.warn("Received UnknownCloudFoundryException from cf with payload={}", (Object)((UnknownCloudFoundryException)e).getPayload());
            } else {
                this.logger.warn("Received error from cf", e);
            }
        }).retryWhen((Function)Retry.onlyIf(c -> {
            this.logger.debug("RetryContext for id {} iteration {} backoff {}", new Object[]{id, c.iteration(), c.backoff()});
            if (c.iteration() > 5L) {
                this.logger.info("Stopping retry for id {} after {} iterations", (Object)id, (Object)c.iteration());
                return false;
            }
            return !c.exception().getClass().getName().contains("org.cloudfoundry.client");
        }).exponentialBackoff(Duration.ofMillis(initialRetryDelay), Duration.ofMillis(statusTimeout)).doOnRetry(c -> this.logger.debug("Retrying cf call for {}", (Object)id))).doOnError(TimeoutException.class, e -> this.logger.error("Retry operation on getStatus failed for {}. Max retry time {}ms", (Object)id, (Object)statusTimeout));
    }

    protected void deleteLocalApplicationResourceFile(AppDeploymentRequest appDeploymentRequest) {
        try {
            Optional<File> fileToDelete = this.fileToDelete(appDeploymentRequest.getResource());
            if (fileToDelete.isPresent()) {
                File applicationFile = fileToDelete.get();
                this.logger.info("Free Disk Space = {} bytes, Total Disk Space = {} bytes", (Object)applicationFile.getFreeSpace(), (Object)applicationFile.getTotalSpace());
                boolean deleted = this.deleteFileOrDirectory(applicationFile);
                this.logger.info(deleted ? "Successfully deleted the application resource: " + applicationFile.getCanonicalPath() : "Could not delete the application resource: " + applicationFile.getCanonicalPath());
            }
        }
        catch (IOException e) {
            this.logger.warn("Exception deleting the application resource after successful CF push request. This could cause increase in disk space usage. Exception message: " + e.getMessage());
        }
    }

    private Optional<File> fileToDelete(Resource resource) throws IOException {
        String scheme = resource.getURI().getScheme().toLowerCase();
        if (scheme.startsWith("http")) {
            return Optional.of(resource.getFile());
        }
        if (scheme.equals("maven") && this.deploymentProperties.isAutoDeleteMavenArtifacts()) {
            return Optional.of(resource.getFile().getParentFile());
        }
        return Optional.empty();
    }

    private boolean deleteFileOrDirectory(File fileToDelete) {
        boolean deleted = fileToDelete.isDirectory() ? FileSystemUtils.deleteRecursively((File)fileToDelete) : fileToDelete.delete();
        return deleted;
    }

    protected Map<String, String> getEnvironmentVariables(String deploymentId, AppDeploymentRequest request) {
        HashMap<String, String> envVariables = new HashMap<String, String>();
        envVariables.putAll(this.getApplicationProperties(deploymentId, request));
        envVariables.putAll(this.getDeclaredEnvironmentVariables(request));
        String javaOpts = this.javaOpts(request);
        if (StringUtils.hasText((String)javaOpts)) {
            envVariables.put("JAVA_OPTS", this.javaOpts(request));
        }
        if (this.hasCfEnv(request.getResource())) {
            Map<String, String> env = CfEnvConfigurer.disableJavaBuildPackAutoReconfiguration(this.deploymentProperties.getEnv());
            env.putAll(CfEnvConfigurer.activateCloudProfile(env, null));
            this.deploymentProperties.setEnv(env);
        }
        envVariables.putAll(this.deploymentProperties.getEnv());
        return envVariables;
    }

    private Map<? extends String, ? extends String> getDeclaredEnvironmentVariables(AppDeploymentRequest request) {
        LinkedHashMap env = new LinkedHashMap();
        request.getDeploymentProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("spring.cloud.deployer.cloudfoundry.env.")).forEach(e -> {
            String cfr_ignored_0 = (String)env.put(((String)e.getKey()).substring("spring.cloud.deployer.cloudfoundry.env".length() + 1), e.getValue());
        });
        return env;
    }

    protected boolean hasCfEnv(Resource resource) {
        if (resource instanceof CfEnvAwareResource) {
            return ((CfEnvAwareResource)resource).hasCfEnv();
        }
        return CfEnvAwareResource.of(resource).hasCfEnv();
    }

    private Map<String, String> getApplicationProperties(String deploymentId, AppDeploymentRequest request) {
        Map<String, String> applicationProperties = this.getSanitizedApplicationProperties(deploymentId, request);
        if (!this.useSpringApplicationJson(request)) {
            return applicationProperties;
        }
        try {
            return Collections.singletonMap("SPRING_APPLICATION_JSON", OBJECT_MAPPER.writeValueAsString(applicationProperties));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getSanitizedApplicationProperties(String deploymentId, AppDeploymentRequest request) {
        Map<String, String> applicationProperties = new HashMap<String, String>(request.getDefinition().getProperties());
        Optional.ofNullable(applicationProperties.remove("server.port")).ifPresent(port -> this.logger.warn("Ignoring 'server.port={}' for app {}, as Cloud Foundry will assign a local dynamic port. Route to the app will use port 80.", port, (Object)deploymentId));
        if (this.hasCfEnv(request.getResource())) {
            applicationProperties = CfEnvConfigurer.activateCloudProfile(applicationProperties, "spring.profiles.active");
        }
        return applicationProperties;
    }

    private boolean useSpringApplicationJson(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.use-spring-application-json")).map(Boolean::valueOf).orElse(this.deploymentProperties.isUseSpringApplicationJson());
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return this.runtimeEnvironmentInfo;
    }
}

