/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.time.Duration;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v3.tasks.CancelTaskRequest;
import org.cloudfoundry.client.v3.tasks.CancelTaskResponse;
import org.cloudfoundry.client.v3.tasks.GetTaskRequest;
import org.cloudfoundry.client.v3.tasks.GetTaskResponse;
import org.cloudfoundry.client.v3.tasks.ListTasksRequest;
import org.cloudfoundry.client.v3.tasks.TaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.cloudfoundry.AbstractCloudFoundryDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import reactor.core.publisher.Mono;

abstract class AbstractCloudFoundryTaskLauncher
extends AbstractCloudFoundryDeployer
implements TaskLauncher {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCloudFoundryTaskLauncher.class);
    private final CloudFoundryClient client;

    AbstractCloudFoundryTaskLauncher(CloudFoundryClient client, CloudFoundryDeploymentProperties deploymentProperties, RuntimeEnvironmentInfo runtimeEnvironmentInfo) {
        super(deploymentProperties, runtimeEnvironmentInfo);
        this.client = client;
    }

    public void cancel(String id) {
        this.requestCancelTask(id).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).doOnSuccess(r -> logger.info("Task {} cancellation successful", (Object)id)).doOnError(this.logError(String.format("Task %s cancellation failed", id))).subscribe();
    }

    public TaskStatus status(String id) {
        try {
            return (TaskStatus)this.getStatus(id).doOnSuccess(v -> logger.info("Successfully computed status [{}] for id={}", v, (Object)id)).doOnError(this.logError(String.format("Failed to compute status for %s", id))).block(Duration.ofMillis(this.deploymentProperties.getStatusTimeout()));
        }
        catch (Exception timeoutDueToBlock) {
            logger.error("Caught exception while querying for status of id={}", (Object)id, (Object)timeoutDueToBlock);
            return this.createErrorTaskStatus(id);
        }
    }

    public int getRunningTaskExecutionCount() {
        ListTasksRequest listTasksRequest = ListTasksRequest.builder().state(TaskState.RUNNING).build();
        return (Integer)this.client.tasks().list(listTasksRequest).map(listTasksResponse -> listTasksResponse.getPagination().getTotalResults()).doOnError(this.logError("Failed to list running tasks")).doOnSuccess(count -> logger.info(String.format("There are %d running tasks", count))).block(Duration.ofMillis(this.deploymentProperties.getStatusTimeout()));
    }

    public int getMaximumConcurrentTasks() {
        return this.deploymentProperties.getMaximumConcurrentTasks();
    }

    protected boolean maxConcurrentExecutionsReached() {
        return this.getRunningTaskExecutionCount() >= this.getMaximumConcurrentTasks();
    }

    private Mono<TaskStatus> getStatus(String id) {
        return this.requestGetTask(id).map(this::toTaskStatus).onErrorResume(this.isNotFoundError(), t -> {
            logger.debug("Task for id={} does not exist", (Object)id);
            return Mono.just((Object)new TaskStatus(id, LaunchState.unknown, null));
        }).transform(this.statusRetry(id)).onErrorReturn((Object)this.createErrorTaskStatus(id));
    }

    private TaskStatus createErrorTaskStatus(String id) {
        return new TaskStatus(id, LaunchState.error, null);
    }

    protected TaskStatus toTaskStatus(GetTaskResponse response) {
        switch (response.getState()) {
            case SUCCEEDED: {
                return new TaskStatus(response.getId(), LaunchState.complete, null);
            }
            case RUNNING: {
                return new TaskStatus(response.getId(), LaunchState.running, null);
            }
            case PENDING: {
                return new TaskStatus(response.getId(), LaunchState.launching, null);
            }
            case CANCELING: {
                return new TaskStatus(response.getId(), LaunchState.cancelled, null);
            }
            case FAILED: {
                return new TaskStatus(response.getId(), LaunchState.failed, null);
            }
        }
        throw new IllegalStateException(String.format("Unsupported CF task state %s", response.getState()));
    }

    private Mono<CancelTaskResponse> requestCancelTask(String taskId) {
        return this.client.tasks().cancel(CancelTaskRequest.builder().taskId(taskId).build());
    }

    private Mono<GetTaskResponse> requestGetTask(String taskId) {
        return this.client.tasks().get(GetTaskRequest.builder().taskId(taskId).build());
    }

    public void cleanup(String id) {
    }

    public void destroy(String appName) {
    }
}

