/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.cloudfoundry.AbstractCloudFoundryException;
import org.cloudfoundry.UnknownCloudFoundryException;
import org.cloudfoundry.util.DelayUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class AbstractCloudFoundryDeployer {
    protected final RuntimeEnvironmentInfo runtimeEnvironmentInfo;
    final CloudFoundryDeploymentProperties deploymentProperties;
    private final Logger logger = LoggerFactory.getLogger(AbstractCloudFoundryDeployer.class);

    AbstractCloudFoundryDeployer(CloudFoundryDeploymentProperties deploymentProperties, RuntimeEnvironmentInfo runtimeEnvironmentInfo) {
        this.deploymentProperties = deploymentProperties;
        this.runtimeEnvironmentInfo = runtimeEnvironmentInfo;
    }

    int memory(AppDeploymentRequest request) {
        String withUnit = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.memory", this.deploymentProperties.getMemory());
        return (int)ByteSizeUtils.parseToMebibytes((String)withUnit);
    }

    Set<String> servicesToBind(AppDeploymentRequest request) {
        HashSet<String> services = new HashSet<String>();
        services.addAll(this.deploymentProperties.getServices());
        services.addAll(StringUtils.commaDelimitedListToSet((String)((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services"))));
        return services;
    }

    int diskQuota(AppDeploymentRequest request) {
        String withUnit = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.disk", this.deploymentProperties.getDisk());
        return (int)ByteSizeUtils.parseToMebibytes((String)withUnit);
    }

    String buildpack(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.buildpack")).orElse(this.deploymentProperties.getBuildpack());
    }

    Predicate<Throwable> isNotFoundError() {
        return t -> t instanceof AbstractCloudFoundryException && ((AbstractCloudFoundryException)t).getStatusCode() == HttpStatus.NOT_FOUND.value();
    }

    String getDockerImage(AppDeploymentRequest request) {
        try {
            String uri = request.getResource().getURI().toString();
            if (uri.startsWith("docker:")) {
                return uri.substring("docker:".length());
            }
            return null;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    Path getApplication(AppDeploymentRequest request) {
        try {
            if (!request.getResource().getURI().toString().startsWith("docker:")) {
                return request.getResource().getFile().toPath();
            }
            return null;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected Consumer<Throwable> logError(String msg) {
        return e -> {
            if (e instanceof UnknownCloudFoundryException) {
                this.logger.error(msg + "\nUnknownCloudFoundryException encountered, whose payload follows:\n" + ((UnknownCloudFoundryException)e).getPayload(), e);
            } else {
                this.logger.error(msg, e);
            }
        };
    }

    <T> Function<Mono<T>, Mono<T>> statusRetry(String id) {
        long statusTimeout = this.deploymentProperties.getStatusTimeout();
        long requestTimeout = Math.round((double)statusTimeout * 0.4);
        long initialRetryDelay = Math.round((double)statusTimeout * 0.1);
        if (requestTimeout < 500L) {
            this.logger.info("Computed statusRetry Request timeout = {} ms is below 500ms minimum value.  Setting to 500ms", (Object)requestTimeout);
            requestTimeout = 500L;
        }
        long requestTimeoutToUse = requestTimeout;
        return m -> m.timeout(Duration.ofMillis(requestTimeoutToUse)).doOnError(e -> this.logger.warn(String.format("Error getting status for %s within %sms, Retrying operation.", id, requestTimeoutToUse))).retryWhen(DelayUtils.exponentialBackOffError((Duration)Duration.ofMillis(initialRetryDelay), (Duration)Duration.ofMillis(statusTimeout / 2L), (Duration)Duration.ofMillis(statusTimeout)).andThen(retries -> Flux.from((Publisher)retries).doOnComplete(() -> this.logger.info("Successfully retried getStatus operation status [{}] for {}", (Object)id)))).doOnError(e -> this.logger.error(String.format("Retry operation on getStatus failed for %s.  Max retry time %sms", id, statusTimeout)));
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return this.runtimeEnvironmentInfo;
    }
}

