/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.util.Map;
import java.util.TreeMap;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;

public class CloudFoundryAppInstanceStatus
implements AppInstanceStatus {
    private final InstanceDetail instanceDetail;
    private final ApplicationDetail applicationDetail;
    private final int index;
    private final Map<String, String> attributes = new TreeMap<String, String>();

    public CloudFoundryAppInstanceStatus(ApplicationDetail applicationDetail, InstanceDetail instanceDetail, int index) {
        this.applicationDetail = applicationDetail;
        this.instanceDetail = instanceDetail;
        this.index = index;
    }

    public String getId() {
        return this.applicationDetail.getName() + "-" + this.index;
    }

    public DeploymentState getState() {
        if (this.instanceDetail == null) {
            return DeploymentState.failed;
        }
        switch (this.instanceDetail.getState()) {
            case "STARTING": 
            case "DOWN": {
                return DeploymentState.deploying;
            }
            case "CRASHED": {
                return DeploymentState.failed;
            }
            case "FLAPPING": 
            case "RUNNING": {
                return DeploymentState.deployed;
            }
            case "UNKNOWN": {
                return DeploymentState.unknown;
            }
        }
        throw new IllegalStateException("Unsupported CF state: " + this.instanceDetail.getState());
    }

    public Map<String, String> getAttributes() {
        if (this.instanceDetail != null) {
            if (this.instanceDetail.getCpu() != null) {
                this.attributes.put("metrics.machine.cpu", String.format("%.1f%%", this.instanceDetail.getCpu() * 100.0));
            }
            if (this.instanceDetail.getDiskQuota() != null && this.instanceDetail.getDiskUsage() != null) {
                this.attributes.put("metrics.machine.disk", String.format("%.1f%%", 100.0 * (double)this.instanceDetail.getDiskUsage().longValue() / (double)this.instanceDetail.getDiskQuota().longValue()));
            }
            if (this.instanceDetail.getMemoryQuota() != null && this.instanceDetail.getMemoryUsage() != null) {
                this.attributes.put("metrics.machine.memory", String.format("%.1f%%", 100.0 * (double)this.instanceDetail.getMemoryUsage().longValue() / (double)this.instanceDetail.getMemoryQuota().longValue()));
            }
        }
        this.attributes.put("guid", this.applicationDetail.getName() + ":" + this.index);
        return this.attributes;
    }

    public String toString() {
        return String.format("%s[%s : %s]", this.getClass().getSimpleName(), this.getId(), this.getState());
    }
}

