/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v3.BuildpackData;
import org.cloudfoundry.client.v3.Data;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Type;
import org.cloudfoundry.client.v3.applications.Application;
import org.cloudfoundry.client.v3.applications.CreateApplicationRequest;
import org.cloudfoundry.client.v3.applications.DeleteApplicationRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationDropletsRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationsRequest;
import org.cloudfoundry.client.v3.applications.Relationships;
import org.cloudfoundry.client.v3.droplets.Droplet;
import org.cloudfoundry.client.v3.droplets.DropletResource;
import org.cloudfoundry.client.v3.droplets.GetDropletRequest;
import org.cloudfoundry.client.v3.droplets.GetDropletResponse;
import org.cloudfoundry.client.v3.droplets.StagedResult;
import org.cloudfoundry.client.v3.packages.CreatePackageRequest;
import org.cloudfoundry.client.v3.packages.CreatePackageResponse;
import org.cloudfoundry.client.v3.packages.GetPackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageResponse;
import org.cloudfoundry.client.v3.packages.Package;
import org.cloudfoundry.client.v3.packages.PackageType;
import org.cloudfoundry.client.v3.packages.StagePackageRequest;
import org.cloudfoundry.client.v3.packages.StagePackageResponse;
import org.cloudfoundry.client.v3.packages.State;
import org.cloudfoundry.client.v3.packages.UploadPackageRequest;
import org.cloudfoundry.client.v3.packages.UploadPackageResponse;
import org.cloudfoundry.client.v3.servicebindings.CreateServiceBindingRequest;
import org.cloudfoundry.client.v3.servicebindings.CreateServiceBindingResponse;
import org.cloudfoundry.client.v3.servicebindings.DeleteServiceBindingRequest;
import org.cloudfoundry.client.v3.servicebindings.ListServiceBindingsRequest;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingResource;
import org.cloudfoundry.client.v3.servicebindings.ServiceBindingType;
import org.cloudfoundry.client.v3.tasks.CreateTaskRequest;
import org.cloudfoundry.client.v3.tasks.CreateTaskResponse;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.services.ServiceInstanceSummary;
import org.cloudfoundry.operations.spaces.GetSpaceRequest;
import org.cloudfoundry.operations.spaces.SpaceDetail;
import org.cloudfoundry.util.DelayUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.spi.cloudfoundry.AbstractCloudFoundryTaskLauncher;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundry2630AndLaterTaskLauncher;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CloudFoundry2620AndEarlierTaskLauncher
extends AbstractCloudFoundryTaskLauncher {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundry2630AndLaterTaskLauncher.class);
    private final CloudFoundryClient client;
    private final CloudFoundryDeploymentProperties deploymentProperties;
    private final CloudFoundryOperations operations;
    private final String space;

    public CloudFoundry2620AndEarlierTaskLauncher(CloudFoundryClient client, CloudFoundryDeploymentProperties deploymentProperties, CloudFoundryOperations operations, String space) {
        super(client, deploymentProperties);
        this.client = client;
        this.deploymentProperties = deploymentProperties;
        this.operations = operations;
        this.space = space;
    }

    public String launch(AppDeploymentRequest request) {
        return (String)this.getOrDeployApplication(request).then(application -> this.launchTask(application.getId(), request)).doOnSuccess(r -> logger.info("Task {} launch successful", (Object)request.getDefinition().getName())).doOnError(t -> logger.error(String.format("Task %s launch failed", request.getDefinition().getName()), t)).block(Duration.ofSeconds(this.deploymentProperties.getApiTimeout()));
    }

    @Override
    public void destroy(String appName) {
        this.getOptionalApplication(appName).doOnSuccess(a -> {
            if (a == null) {
                logger.info("Did not destroy app {} as it did not exist", (Object)appName);
            }
        }).then(app -> this.requestListServiceBindings(app.getId()).flatMap(sb -> this.requestDeleteServiceBinding(sb.getId())).then(this.requestDeleteApplication(app.getId())).doOnSuccess(v -> logger.info("Successfully destroyed app {}", (Object)appName)).doOnError(e -> logger.error(String.format("Failed to destroy app %s", appName), e))).timeout(Duration.ofSeconds(this.deploymentProperties.getApiTimeout())).subscribe();
    }

    private Mono<Void> requestDeleteServiceBinding(String sbId) {
        return this.client.serviceBindingsV3().delete(DeleteServiceBindingRequest.builder().serviceBindingId(sbId).build());
    }

    private Flux<ServiceBindingResource> requestListServiceBindings(String appId) {
        return PaginationUtils.requestClientV3Resources(page -> this.client.serviceBindingsV3().list(ListServiceBindingsRequest.builder().applicationId(appId).page(page).build()));
    }

    private Mono<Void> bindServices(AppDeploymentRequest request, Application application) {
        Set<String> servicesToBind = this.servicesToBind(request);
        return this.requestListServiceInstances().filter(instance -> servicesToBind.contains(instance.getName())).map(ServiceInstanceSummary::getId).flatMap(serviceInstanceId -> this.requestCreateServiceBinding(application.getId(), (String)serviceInstanceId)).then();
    }

    private Mono<Application> createApplication(AppDeploymentRequest request, String spaceId) {
        AppDefinition definition = request.getDefinition();
        return this.requestCreateApplication(this.buildpack(request), this.getEnvironmentVariables(definition.getProperties()), definition.getName(), spaceId);
    }

    private Mono<String> createDroplet(String packageId, AppDeploymentRequest request) {
        return this.requestStagePackage(this.diskQuota(request), this.memory(request), packageId).map(Droplet::getId);
    }

    private Mono<String> createPackage(String applicationId) {
        return this.requestCreatePackage(applicationId).map(Package::getId);
    }

    private Mono<String> createTask(String applicationId, Droplet droplet, AppDeploymentRequest request) {
        return this.requestCreateTask(applicationId, this.getCommand(droplet, request), droplet.getId(), this.memory(request), request.getDefinition().getName()).map(CreateTaskResponse::getId);
    }

    private Mono<Application> deployApplication(AppDeploymentRequest request) {
        return this.getSpaceId().then(spaceId -> this.createApplication(request, (String)spaceId)).then(application -> this.uploadPackage(request, application.getId()).then(this.bindServices(request, (Application)application)).then(Mono.just((Object)application)));
    }

    private Path getBits(AppDeploymentRequest request) {
        try {
            return request.getResource().getFile().toPath();
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private String getCommand(Droplet droplet, AppDeploymentRequest request) {
        String defaultCommand = (String)((StagedResult)droplet.getResult()).getProcessTypes().get("web");
        return Stream.concat(Stream.of(defaultCommand), request.getCommandlineArguments().stream()).collect(Collectors.joining(" "));
    }

    private Mono<GetDropletResponse> getDroplet(String applicationId) {
        return this.requestListDroplets(applicationId).single().map(DropletResource::getId).then(this::requestGetDroplet);
    }

    private Map<String, String> getEnvironmentVariables(Map<String, String> properties) {
        try {
            return Collections.singletonMap("SPRING_APPLICATION_JSON", OBJECT_MAPPER.writeValueAsString(properties));
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private Mono<Application> getOptionalApplication(String name) {
        return this.requestListApplications(name).singleOrEmpty();
    }

    private Mono<Application> getOrDeployApplication(AppDeploymentRequest request) {
        return this.getOptionalApplication(request.getDefinition().getName()).otherwiseIfEmpty(this.deployApplication(request));
    }

    private Mono<String> getSpaceId() {
        return this.requestSpace(this.space).map(SpaceDetail::getId);
    }

    private Mono<String> launchTask(String applicationId, AppDeploymentRequest request) {
        return this.getDroplet(applicationId).then(droplet -> this.createTask(applicationId, (Droplet)droplet, request));
    }

    private Mono<Application> requestCreateApplication(String buildpack, Map<String, String> environmentVariables, String name, String spaceId) {
        return this.client.applicationsV3().create(CreateApplicationRequest.builder().environmentVariables(environmentVariables).lifecycle(Lifecycle.builder().type(Type.BUILDPACK).data((Data)BuildpackData.builder().buildpack(buildpack).build()).build()).name(name).relationships(Relationships.builder().space(Relationship.builder().id(spaceId).build()).build()).build()).cast(Application.class);
    }

    private Mono<Void> requestDeleteApplication(String appId) {
        return this.client.applicationsV3().delete(DeleteApplicationRequest.builder().applicationId(appId).build());
    }

    private Mono<CreatePackageResponse> requestCreatePackage(String applicationId) {
        return this.client.packages().create(CreatePackageRequest.builder().applicationId(applicationId).type(PackageType.BITS).build());
    }

    private Mono<CreateServiceBindingResponse> requestCreateServiceBinding(String applicationId, String serviceInstanceId) {
        return this.client.serviceBindingsV3().create(CreateServiceBindingRequest.builder().relationships(org.cloudfoundry.client.v3.servicebindings.Relationships.builder().application(Relationship.builder().id(applicationId).build()).serviceInstance(Relationship.builder().id(serviceInstanceId).build()).build()).type(ServiceBindingType.APPLICATION).build());
    }

    private Mono<CreateTaskResponse> requestCreateTask(String applicationId, String command, String dropletId, int memory, String name) {
        return this.client.tasks().create(CreateTaskRequest.builder().applicationId(applicationId).command(command).dropletId(dropletId).memoryInMb(Integer.valueOf(memory)).name(name).build());
    }

    private Mono<GetDropletResponse> requestGetDroplet(String dropletId) {
        return this.client.droplets().get(GetDropletRequest.builder().dropletId(dropletId).build());
    }

    private Mono<GetPackageResponse> requestGetPackage(String packageId) {
        return this.client.packages().get(GetPackageRequest.builder().packageId(packageId).build());
    }

    private Flux<Application> requestListApplications(String name) {
        return PaginationUtils.requestClientV3Resources(page -> this.client.applicationsV3().list(ListApplicationsRequest.builder().name(name).page(page).build())).cast(Application.class);
    }

    private Flux<DropletResource> requestListDroplets(String applicationId) {
        return PaginationUtils.requestClientV3Resources(page -> this.client.applicationsV3().listDroplets(ListApplicationDropletsRequest.builder().applicationId(applicationId).page(page).build()));
    }

    private Flux<ServiceInstanceSummary> requestListServiceInstances() {
        return this.operations.services().listInstances();
    }

    private Mono<SpaceDetail> requestSpace(String space) {
        return this.operations.spaces().get(GetSpaceRequest.builder().name(space).build());
    }

    private Mono<StagePackageResponse> requestStagePackage(int disk, int memory, String packageId) {
        return this.client.packages().stage(StagePackageRequest.builder().packageId(packageId).stagingDiskInMb(Integer.valueOf(disk)).stagingMemoryInMb(Integer.valueOf(memory)).build());
    }

    private Mono<UploadPackageResponse> requestUploadPackage(Path bits, String packageId) {
        return this.client.packages().upload(UploadPackageRequest.builder().bits(bits).packageId(packageId).build());
    }

    private Mono<GetDropletResponse> uploadPackage(AppDeploymentRequest request, String applicationId) {
        return this.createPackage(applicationId).then(packageId -> this.requestUploadPackage(this.getBits(request), (String)packageId).then(this.waitForPackageProcessing((String)packageId)).then(this.createDroplet((String)packageId, request))).then(this::waitForDropletProcessing);
    }

    private Mono<GetDropletResponse> waitForDropletProcessing(String dropletId) {
        return this.requestGetDroplet(dropletId).filter(response -> !response.getState().equals((Object)org.cloudfoundry.client.v3.droplets.State.PENDING)).repeatWhenEmpty(50, DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(10L), (Duration)Duration.ofMinutes(1L), (Duration)Duration.ofMinutes(10L)));
    }

    private Mono<GetPackageResponse> waitForPackageProcessing(String packageId) {
        return this.requestGetPackage(packageId).filter(response -> response.getState().equals((Object)State.READY)).repeatWhenEmpty(50, DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(5L), (Duration)Duration.ofMinutes(1L), (Duration)Duration.ofMinutes(10L)));
    }
}

