/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.cloudfoundry.AbstractCloudFoundryException;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Hooks;

class AbstractCloudFoundryDeployer {
    final CloudFoundryDeploymentProperties deploymentProperties;
    int shortApiCallsTimeoutMs = 1000;

    AbstractCloudFoundryDeployer(CloudFoundryDeploymentProperties deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
        Hooks.onOperator(op -> op.operatorStacktrace());
    }

    int memory(AppDeploymentRequest request) {
        String withUnit = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.memory", this.deploymentProperties.getMemory());
        return (int)ByteSizeUtils.parseToMebibytes((String)withUnit);
    }

    Set<String> servicesToBind(AppDeploymentRequest request) {
        HashSet<String> services = new HashSet<String>();
        services.addAll(this.deploymentProperties.getServices());
        services.addAll(StringUtils.commaDelimitedListToSet((String)((String)request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.services"))));
        return services;
    }

    int diskQuota(AppDeploymentRequest request) {
        String withUnit = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.disk", this.deploymentProperties.getDisk());
        return (int)ByteSizeUtils.parseToMebibytes((String)withUnit);
    }

    String buildpack(AppDeploymentRequest request) {
        return Optional.ofNullable(request.getDeploymentProperties().get("spring.cloud.deployer.cloudfoundry.buildpack")).orElse(this.deploymentProperties.getBuildpack());
    }

    Predicate<Throwable> isNotFoundError() {
        return t -> t instanceof AbstractCloudFoundryException && ((AbstractCloudFoundryException)t).getStatusCode() == HttpStatus.NOT_FOUND.value();
    }
}

