/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.doppler.ReactorDopplerClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.cloudfoundry.reactor.uaa.ReactorUaaClient;
import org.cloudfoundry.uaa.UaaClient;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.AppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryTaskLauncher;
import org.springframework.cloud.deployer.spi.cloudfoundry.WordListRandomWords;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CloudFoundryConnectionProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class CloudFoundryDeployerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"appDeploymentProperties"})
    public CloudFoundryDeploymentProperties appDeploymentProperties() {
        return this.defaultSharedDeploymentProperties();
    }

    @Bean
    @ConditionalOnMissingBean(name={"taskDeploymentProperties"})
    public CloudFoundryDeploymentProperties taskDeploymentProperties() {
        return this.defaultSharedDeploymentProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry")
    public CloudFoundryDeploymentProperties defaultSharedDeploymentProperties() {
        return new CloudFoundryDeploymentProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionContext connectionContext(CloudFoundryConnectionProperties properties) {
        return DefaultConnectionContext.builder().apiHost(properties.getUrl().getHost()).skipSslValidation(properties.isSkipSslValidation()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenProvider tokenProvider(CloudFoundryConnectionProperties properties) {
        return PasswordGrantTokenProvider.builder().username(properties.getUsername()).password(properties.getPassword()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudFoundryClient cloudFoundryClient(ConnectionContext connectionContext, TokenProvider tokenProvider) {
        return ReactorCloudFoundryClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudFoundryOperations cloudFoundryOperations(CloudFoundryClient cloudFoundryClient, ConnectionContext connectionContext, TokenProvider tokenProvider, CloudFoundryConnectionProperties properties) {
        ReactorDopplerClient dopplerClient = ReactorDopplerClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
        ReactorUaaClient uaaClient = ReactorUaaClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
        return DefaultCloudFoundryOperations.builder().cloudFoundryClient(cloudFoundryClient).dopplerClient((DopplerClient)dopplerClient).uaaClient((UaaClient)uaaClient).organization(properties.getOrg()).space(properties.getSpace()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={AppDeployer.class})
    public AppDeployer appDeployer(CloudFoundryConnectionProperties connectionProperties, CloudFoundryOperations operations, CloudFoundryClient client, AppNameGenerator appDeploymentCustomizer) {
        return new CloudFoundryAppDeployer(connectionProperties, this.appDeploymentProperties(), operations, client, appDeploymentCustomizer);
    }

    @Bean
    @ConditionalOnMissingBean(value={AppNameGenerator.class})
    public AppNameGenerator appDeploymentCustomizer() {
        return new CloudFoundryAppNameGenerator(this.appDeploymentProperties(), new WordListRandomWords());
    }

    @Bean
    @ConditionalOnMissingBean(value={TaskLauncher.class})
    public TaskLauncher taskLauncher(CloudFoundryClient client, CloudFoundryConnectionProperties connectionProperties, CloudFoundryOperations operations) {
        return new CloudFoundryTaskLauncher(client, operations, connectionProperties, this.taskDeploymentProperties());
    }
}

