/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.deployer.spi.cloudfoundry.AppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.WordListRandomWords;
import org.springframework.util.StringUtils;

public class CloudFoundryAppNameGenerator
implements AppNameGenerator,
InitializingBean {
    private static final Log logger = LogFactory.getLog(CloudFoundryAppNameGenerator.class);
    private String prefixToUse = "";
    private final CloudFoundryDeploymentProperties properties;
    private final WordListRandomWords wordListRandomWords;

    public CloudFoundryAppNameGenerator(CloudFoundryDeploymentProperties cloudFoundryDeploymentProperties, WordListRandomWords wordListRandomWords) {
        this.properties = cloudFoundryDeploymentProperties;
        this.wordListRandomWords = wordListRandomWords;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.properties.isEnableRandomAppNamePrefix()) {
            this.prefixToUse = this.createUniquePrefix();
            if (!StringUtils.isEmpty((Object)this.properties.getAppNamePrefix())) {
                this.prefixToUse = String.format("%s-%s", this.properties.getAppNamePrefix(), this.prefixToUse);
            }
        } else if (!StringUtils.isEmpty((Object)this.properties.getAppNamePrefix())) {
            this.prefixToUse = this.properties.getAppNamePrefix();
        }
        logger.info((Object)String.format("Prefix to be used for deploying apps: %s", this.prefixToUse));
    }

    @Override
    public String generateAppName(String appName) {
        if (StringUtils.isEmpty((Object)this.prefixToUse)) {
            return appName;
        }
        return String.format("%s-%s", this.prefixToUse, appName);
    }

    private String createUniquePrefix() {
        return String.format("%s-%s", this.wordListRandomWords.getAdjective(), this.wordListRandomWords.getNoun());
    }
}

