/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.cloudfoundry.config.security.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.security.support.AccessLevel;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.security.support.CloudFoundryAuthorizationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class CloudFoundrySecurityService {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundrySecurityService.class);
    private final OAuth2RestTemplate oAuth2RestTemplate;
    private final String cloudControllerUrl;
    private final String applicationId;

    public CloudFoundrySecurityService(OAuth2RestTemplate oAuth2RestTemplate, String cloudControllerUrl, String applicationId) {
        Assert.notNull((Object)oAuth2RestTemplate, (String)"OAuth2RestTemplate must not be null.");
        Assert.notNull((Object)cloudControllerUrl, (String)"CloudControllerUrl must not be null.");
        Assert.notNull((Object)applicationId, (String)"ApplicationId must not be null.");
        this.oAuth2RestTemplate = oAuth2RestTemplate;
        this.cloudControllerUrl = cloudControllerUrl;
        this.applicationId = applicationId;
    }

    public boolean isSpaceDeveloper() {
        OAuth2AccessToken accessToken = this.oAuth2RestTemplate.getAccessToken();
        logger.info("The accessToken is: " + accessToken.getValue());
        AccessLevel accessLevel = this.getAccessLevel(accessToken.getValue(), this.applicationId);
        return AccessLevel.FULL.equals((Object)accessLevel);
    }

    public AccessLevel getAccessLevel(String token, String applicationId) throws CloudFoundryAuthorizationException {
        try {
            URI permissionsUri = this.getPermissionsUri(applicationId);
            logger.info("Using PermissionsUri: " + permissionsUri);
            RequestEntity request = RequestEntity.get((URI)permissionsUri).header("Authorization", new String[]{"bearer " + token}).build();
            Map body = (Map)this.oAuth2RestTemplate.exchange(request, Map.class).getBody();
            if (Boolean.TRUE.equals(body.get("read_sensitive_data"))) {
                return AccessLevel.FULL;
            }
            return AccessLevel.RESTRICTED;
        }
        catch (HttpClientErrorException ex) {
            if (ex.getStatusCode().equals((Object)HttpStatus.FORBIDDEN)) {
                return AccessLevel.NONE;
            }
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_TOKEN, "Invalid token", ex);
        }
        catch (HttpServerErrorException ex) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Cloud controller not reachable");
        }
    }

    private URI getPermissionsUri(String applicationId) {
        try {
            return new URI(this.cloudControllerUrl + "/v2/apps/" + applicationId + "/permissions");
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

