/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.cloudfoundry.config.security.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.cloud.common.security.support.CoreSecurityRoles;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.security.support.CloudFoundrySecurityService;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CloudFoundryDataflowAuthoritiesExtractor
implements AuthoritiesExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryDataflowAuthoritiesExtractor.class);
    private final CloudFoundrySecurityService cloudFoundrySecurityService;

    public CloudFoundryDataflowAuthoritiesExtractor(CloudFoundrySecurityService cloudFoundrySecurityService) {
        this.cloudFoundrySecurityService = cloudFoundrySecurityService;
    }

    public List<GrantedAuthority> extractAuthorities(Map<String, Object> map) {
        Assert.notNull(map, (String)"The map argument must not be null.");
        if (this.cloudFoundrySecurityService.isSpaceDeveloper()) {
            ArrayList rolesAsStrings = new ArrayList();
            List<GrantedAuthority> grantedAuthorities = Stream.of(CoreSecurityRoles.values()).map(roleEnum -> {
                String roleName = "ROLE_" + roleEnum.getKey();
                rolesAsStrings.add(roleName);
                return new SimpleGrantedAuthority(roleName);
            }).collect(Collectors.toList());
            logger.info("Adding ALL roles {} to Cloud Foundry Space Developer user {}", (Object)StringUtils.collectionToCommaDelimitedString(rolesAsStrings), map);
            return grantedAuthorities;
        }
        return new ArrayList<GrantedAuthority>(0);
    }
}

