/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.dsl.task;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.SchedulerOperations;
import org.springframework.cloud.dataflow.rest.client.dsl.task.Task;
import org.springframework.cloud.dataflow.rest.client.dsl.task.TaskScheduleBuilder;
import org.springframework.util.Assert;

public class TaskSchedule
implements AutoCloseable {
    public static final String CRON_EXPRESSION_KEY = "scheduler.cron.expression";
    private final String scheduleName;
    private final SchedulerOperations schedulerOperations;
    private final Task task;

    TaskSchedule(String scheduleName, Task task, SchedulerOperations schedulerOperations) {
        this.scheduleName = scheduleName;
        this.task = task;
        this.schedulerOperations = schedulerOperations;
    }

    public static TaskScheduleBuilder builder(DataFlowOperations dataFlowOperations) {
        return new TaskScheduleBuilder(dataFlowOperations);
    }

    public void schedule(String cronExpression, Map<String, String> scheduleProperties, String ... taskArgs) {
        Assert.isTrue((!this.isScheduled() ? 1 : 0) != 0, (String)"Task already scheduled!");
        Assert.hasText((String)cronExpression, (String)"cronExpression must not be empty or null");
        HashMap<String, String> updatedProperties = new HashMap<String, String>(scheduleProperties);
        updatedProperties.put(CRON_EXPRESSION_KEY, cronExpression);
        this.schedulerOperations.schedule(this.scheduleName, this.task.getTaskName(), updatedProperties, Arrays.asList(taskArgs));
    }

    public void unschedule() {
        this.schedulerOperations.unschedule(this.scheduleName);
    }

    public boolean isScheduled() {
        return this.schedulerOperations.list(this.task.getTaskName()).getContent().stream().anyMatch(sr -> sr.getScheduleName().equals(this.scheduleName));
    }

    public Map<String, String> getScheduleProperties() {
        Assert.isTrue((boolean)this.isScheduled(), (String)"Only scheduled task can have properties");
        return this.schedulerOperations.getSchedule(this.scheduleName).getScheduleProperties();
    }

    public Task getTask() {
        return this.task;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    @Override
    public void close() {
        if (this.isScheduled()) {
            this.unschedule();
        }
    }
}

