/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.dsl;

import java.util.Map;
import org.springframework.cloud.dataflow.rest.client.dsl.AbstractPropertiesBuilder;
import org.springframework.util.Assert;

public class SkipperDeploymentPropertiesBuilder
extends AbstractPropertiesBuilder {
    public SkipperDeploymentPropertiesBuilder() {
    }

    public SkipperDeploymentPropertiesBuilder(Map<String, String> map) {
        this.deploymentProperties.putAll(map);
    }

    public SkipperDeploymentPropertiesBuilder put(String key, String value) {
        this.deploymentProperties.put(key, value.toString());
        return this;
    }

    public SkipperDeploymentPropertiesBuilder putAll(Map<String, String> map) {
        this.deploymentProperties.putAll(map);
        return this;
    }

    public SkipperDeploymentPropertiesBuilder memory(String label, Integer memory) {
        Assert.notNull((Object)memory, (String)"Memory value can't be null");
        Assert.hasLength((String)label, (String)"Application name/label can not be empty");
        Assert.isTrue((memory >= 128 ? 1 : 0) != 0, (String)"Memory value must be greater or equal than 128mb");
        this.deploymentProperties.put(String.format("deployer.%s.%s", label, "memory"), memory.toString());
        return this;
    }

    public SkipperDeploymentPropertiesBuilder count(String label, Integer instances) {
        Assert.notNull((Object)instances, (String)"Number of instances can't be null");
        Assert.hasLength((String)label, (String)"Application name/label can not be empty");
        Assert.isTrue((instances > 0 ? 1 : 0) != 0, (String)"Number of instances must be greater than zero");
        this.deploymentProperties.put(String.format("deployer.%s.%s", label, "count"), instances.toString());
        return this;
    }

    public SkipperDeploymentPropertiesBuilder platformName(String platformName) {
        Assert.hasLength((String)platformName, (String)"Platform can't be empty");
        this.deploymentProperties.put("spring.cloud.dataflow.skipper.platformName", platformName);
        return this;
    }

    public SkipperDeploymentPropertiesBuilder packageVersion(String packageVersion) {
        Assert.hasLength((String)packageVersion, (String)"Package version can't be empty");
        this.deploymentProperties.put("spring.cloud.dataflow.skipper.packageVersion", packageVersion);
        return this;
    }

    public SkipperDeploymentPropertiesBuilder repoName(String repoName) {
        Assert.hasLength((String)repoName, (String)"Repository name can't be empty");
        this.deploymentProperties.put("spring.cloud.dataflow.skipper.repoName", repoName);
        return this;
    }
}

