/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class DockerImage {
    public static final String SECTION_SEPARATOR = "/";
    public static final String TAG_SEPARATOR = ":";
    public static final String DEFAULT_NAMESPACE = "library";
    public static final String DEFAULT_TAG = "latest";
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("[a-z0-9_]+");
    private static final List<String> OFFICIAL_REGISTRY_LIST = Collections.unmodifiableList(Arrays.asList("registry.hub.docker.com", "docker.io"));
    private String host;
    private String namespace;
    private String repository;
    private String tag;

    public static DockerImage fromImageName(String imageName) {
        String[] parts = imageName.split(SECTION_SEPARATOR);
        switch (parts.length) {
            case 0: {
                throw new IllegalArgumentException("Invalid image format: " + imageName);
            }
            case 1: {
                return DockerImage.fromParts(null, null, parts[0]);
            }
            case 2: {
                if (DockerImage.isValidNamespace(parts[0])) {
                    return DockerImage.fromParts(null, parts[0], parts[1]);
                }
                return DockerImage.fromParts(parts[0], null, parts[1]);
            }
        }
        String host = parts[0];
        String repo = parts[parts.length - 1];
        String namespace = imageName.substring(host.length() + SECTION_SEPARATOR.length(), imageName.length() - repo.length() - SECTION_SEPARATOR.length());
        return DockerImage.fromParts(host, namespace, repo);
    }

    public static DockerImage fromParts(String hostPart, String namespacePart, String repoAndTagPart) {
        String[] repoParts = repoAndTagPart.split(TAG_SEPARATOR);
        switch (repoParts.length) {
            case 1: {
                return DockerImage.fromParts(hostPart, namespacePart, repoParts[0], DEFAULT_TAG);
            }
            case 2: {
                return DockerImage.fromParts(hostPart, namespacePart, repoParts[0], repoParts[1]);
            }
        }
        throw new IllegalArgumentException("Invalid repository and tag format: " + repoAndTagPart);
    }

    public static DockerImage fromParts(String hostPart, String namespacePart, String repo, String tag) {
        DockerImage dockerImage = new DockerImage();
        dockerImage.host = hostPart;
        dockerImage.namespace = namespacePart;
        dockerImage.repository = repo;
        dockerImage.tag = tag;
        return dockerImage;
    }

    public static boolean isValidNamespace(String namespaceCandidate) {
        return NAMESPACE_PATTERN.matcher(namespaceCandidate).matches();
    }

    public String getHost() {
        return this.host;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getNamespaceAndRepo() {
        if (this.namespace != null) {
            return this.namespace + SECTION_SEPARATOR + this.repository;
        }
        if (this.isDockerHubImage()) {
            return "library/" + this.repository;
        }
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isDockerHubImage() {
        return this.host == null || OFFICIAL_REGISTRY_LIST.contains(this.host);
    }

    public String toString() {
        StringBuilder imageName = new StringBuilder();
        if (!this.isDockerHubImage()) {
            imageName.append(this.host);
            imageName.append(SECTION_SEPARATOR);
        }
        imageName.append(this.getNamespaceAndRepo());
        if (this.tag != null) {
            imageName.append(TAG_SEPARATOR);
            imageName.append(this.tag);
        }
        return imageName.toString();
    }
}

