/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.registry.AppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;
import org.springframework.cloud.dataflow.registry.support.AppResourceCommon;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractAppRegistryCommon
implements AppRegistryCommon {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAppRegistryCommon.class);
    public static final String METADATA_KEY_SUFFIX = "metadata";
    private AppResourceCommon appResourceCommon;
    protected static final Function<Map.Entry<Object, Object>, AbstractMap.SimpleImmutableEntry<String, URI>> toStringAndUriFunc = kv -> {
        try {
            return new AbstractMap.SimpleImmutableEntry<String, URI>((String)kv.getKey(), new URI((String)kv.getValue()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    };

    public AbstractAppRegistryCommon(AppResourceCommon appResourceService) {
        this.appResourceCommon = appResourceService;
    }

    @Override
    public Resource getAppResource(AppRegistration appRegistration) {
        return this.appResourceCommon.getResource(appRegistration.getUri().toString());
    }

    @Override
    public Resource getAppMetadataResource(AppRegistration appRegistration) {
        return this.appResourceCommon.getMetadataResource(appRegistration.getUri(), appRegistration.getMetadataUri());
    }

    @Override
    public String getResourceVersion(Resource resource) {
        return this.appResourceCommon.getResourceVersion(resource);
    }

    @Override
    public String getResourceWithoutVersion(Resource resource) {
        return this.appResourceCommon.getResourceWithoutVersion(resource);
    }

    @Override
    public String getResourceVersion(String uriString) {
        return this.getResourceVersion(this.appResourceCommon.getResource(uriString));
    }

    private String getVersionOrBroken(String uri) {
        try {
            return this.getResourceVersion(uri);
        }
        catch (IllegalStateException ise) {
            logger.warn("", (Throwable)ise);
            return "broken";
        }
    }

    protected Properties loadProperties(Resource resource) {
        try {
            return PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from " + resource.getDescription(), e);
        }
    }

    @Override
    public List<AppRegistration> importAll(boolean overwrite, Resource ... resources) {
        return Stream.of(resources).map(this::loadProperties).flatMap(prop -> prop.entrySet().stream().map(toStringAndUriFunc).flatMap(kv -> this.toValidAppRegistration((Map.Entry<String, URI>)kv, this.metadataUriFromProperties((String)kv.getKey(), (Properties)prop))).filter(a -> this.isOverwrite((AppRegistration)a, overwrite)).map(ar -> this.save((AppRegistration)ar))).collect(Collectors.toList());
    }

    protected abstract boolean isOverwrite(AppRegistration var1, boolean var2);

    protected Stream<AppRegistration> toValidAppRegistration(Map.Entry<String, URI> kv, URI metadataURI) {
        String key = kv.getKey();
        String[] tokens = key.split("\\.");
        if (tokens.length == 2) {
            String name = tokens[1];
            ApplicationType type = ApplicationType.valueOf((String)tokens[0]);
            URI appURI = this.warnOnMalformedURI(key, kv.getValue());
            String version = this.getVersionOrBroken(appURI.toString());
            return Stream.of(new AppRegistration(name, type, version, appURI, metadataURI));
        }
        Assert.isTrue((tokens.length == 3 && METADATA_KEY_SUFFIX.equals(tokens[2]) ? 1 : 0) != 0, (String)("Invalid format for app key '" + key + "'in file. Must be <type>.<name> or <type>.<name>.metadata"));
        return Stream.empty();
    }

    protected URI metadataUriFromProperties(String key, Properties properties) {
        String metadataValue = properties.getProperty(key + "." + METADATA_KEY_SUFFIX);
        try {
            return metadataValue != null ? this.warnOnMalformedURI(key, new URI(metadataValue)) : null;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected URI warnOnMalformedURI(String key, URI uri) {
        if (StringUtils.isEmpty((Object)uri)) {
            logger.warn(String.format("Error when registering '%s': URI is required", key));
        } else if (!StringUtils.hasText((String)uri.getScheme())) {
            logger.warn(String.format("Error when registering '%s' with URI %s: URI scheme must be specified", key, uri));
        } else if (!StringUtils.hasText((String)uri.getSchemeSpecificPart())) {
            logger.warn(String.format("Error when registering '%s' with URI %s: URI scheme-specific part must be specified", key, uri));
        }
        return uri;
    }
}

