/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.app.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.ItemHint;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;
import org.springframework.boot.configurationprocessor.metadata.JsonMarshaller;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Mojo(name="aggregate-metadata", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class MetadataAggregationMojo
extends AbstractMojo {
    static final String METADATA_PATH = "META-INF/spring-configuration-metadata.json";
    static final String VISIBLE_PROPERTIES_PATH = "META-INF/dataflow-configuration-metadata.properties";
    static final String DEPRECATED_WHITELIST_PATH = "META-INF/dataflow-configuration-metadata-whitelist.properties";
    static final String DEPRECATED_BACKUP_WHITELIST_PATH = "META-INF/spring-configuration-metadata-whitelist.properties";
    static final String CONFIGURATION_PROPERTIES_CLASSES = "configuration-properties.classes";
    static final String CONFIGURATION_PROPERTIES_NAMES = "configuration-properties.names";
    static final String CONFIGURATION_PROPERTIES_INBOUND_PORTS = "configuration-properties.inbound-ports";
    static final String CONFIGURATION_PROPERTIES_OUTBOUND_PORTS = "configuration-properties.outbound-ports";
    static final String SPRING_CLOUD_FUNCTION_DEFINITION = "spring.cloud.function.definition";
    static final String SPRING_CLOUD_STREAM_FUNCTION_DEFINITION = "spring.cloud.stream.function.definition";
    static final String SPRING_CLOUD_STREAM_FUNCTION_BINDINGS = "spring.cloud.stream.function.bindings";
    static final String SPRING_CLOUD_DATAFLOW_PORT_MAPPING_PROPERTIES = "dataflow-configuration-port-mapping.properties";
    static final String SPRING_CLOUD_DATAFLOW_OPTION_GROUPS_PROPERTIES = "dataflow-configuration-option-groups.properties";
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(defaultValue="metadata")
    private String classifier;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private boolean storeFilteredMetadata;
    @Parameter
    private MetadataFilter metadataFilter;
    private final JsonMarshaller jsonMarshaller = new JsonMarshaller();

    public void execute() throws MojoExecutionException {
        Result result = new Result(this.gatherConfigurationMetadata(null), this.gatherVisibleMetadata());
        this.produceArtifact(result);
        if (this.storeFilteredMetadata) {
            String[] names;
            String[] sourceTypes;
            this.getLog().debug((CharSequence)("propertyClassFilter: " + this.metadataFilter));
            if (this.metadataFilter == null) {
                this.metadataFilter = new MetadataFilter();
            }
            if (result.visible.containsKey(CONFIGURATION_PROPERTIES_CLASSES) && (sourceTypes = result.visible.getProperty(CONFIGURATION_PROPERTIES_CLASSES, "").split(",")) != null && sourceTypes.length > 0) {
                if (this.metadataFilter.getSourceTypes() == null) {
                    this.metadataFilter.setSourceTypes(new ArrayList<String>());
                }
                for (String sourceType : sourceTypes) {
                    sourceType = sourceType.trim();
                    if (this.metadataFilter.getSourceTypes().contains(sourceType)) continue;
                    this.metadataFilter.getSourceTypes().add(sourceType);
                }
            }
            if (result.visible.containsKey(CONFIGURATION_PROPERTIES_NAMES) && (names = result.visible.getProperty(CONFIGURATION_PROPERTIES_NAMES, "").split(",")) != null && names.length > 0) {
                if (this.metadataFilter.getNames() == null) {
                    this.metadataFilter.setNames(new ArrayList<String>());
                }
                for (String name : names) {
                    name = name.trim();
                    if (this.metadataFilter.getNames().contains(name)) continue;
                    this.metadataFilter.getNames().add(name);
                }
            }
            if (result.visible.containsKey(CONFIGURATION_PROPERTIES_CLASSES)) {
                sourceTypes = result.visible.getProperty(CONFIGURATION_PROPERTIES_CLASSES, "").split(",");
                this.metadataFilter.getSourceTypes().addAll(Arrays.asList(sourceTypes));
            }
            this.storeFilteredMetadata();
        }
        this.storeInboundOutboundPortMappingConfigurations(result.getPortMappingProperties());
    }

    private void storeFilteredMetadata() throws MojoExecutionException {
        File projectMetaInfFolder = new File(this.mavenProject.getBuild().getOutputDirectory(), "META-INF");
        if (!projectMetaInfFolder.exists() && !projectMetaInfFolder.mkdir()) {
            throw new MojoExecutionException("Error creating META-INF folder for port mapping file!");
        }
        try (FileWriter fileWriter = new FileWriter(new File(projectMetaInfFolder, "spring-configuration-metadata-encoded.properties"));){
            ConfigurationMetadata metadata = this.gatherConfigurationMetadata(this.metadataFilter);
            String escapedJson = StringEscapeUtils.escapeJson((String)this.toJson(metadata));
            fileWriter.write("org.springframework.cloud.dataflow.spring.configuration.metadata.json=" + escapedJson);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file ", (Exception)e);
        }
    }

    private void storeInboundOutboundPortMappingConfigurations(Properties properties) throws MojoExecutionException {
        File projectMetaInfFolder = new File(this.mavenProject.getBuild().getOutputDirectory(), "META-INF");
        if (!projectMetaInfFolder.exists() && !projectMetaInfFolder.mkdir()) {
            throw new MojoExecutionException("Error creating META-INF folder for port mapping file!");
        }
        try (FileWriter fileWriter = new FileWriter(new File(projectMetaInfFolder, SPRING_CLOUD_DATAFLOW_PORT_MAPPING_PROPERTIES));){
            properties.store(fileWriter, "Spring Cloud DataFlow Port Mapping");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file ", (Exception)e);
        }
    }

    private String toJson(ConfigurationMetadata metadata) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.jsonMarshaller.write(metadata, (OutputStream)baos);
        String json = baos.toString();
        json = json.replaceAll("\\$\\{", "{");
        return json;
    }

    Properties gatherVisibleMetadata() throws MojoExecutionException {
        Properties visible = new Properties();
        ArrayList<String> inboundPorts = new ArrayList<String>();
        ArrayList<String> outboundPorts = new ArrayList<String>();
        try {
            block20: for (String path : this.mavenProject.getRuntimeClasspathElements()) {
                if (Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0])) {
                    for (String visibleProperties : new String[]{VISIBLE_PROPERTIES_PATH, DEPRECATED_WHITELIST_PATH, DEPRECATED_BACKUP_WHITELIST_PATH}) {
                        Optional<Properties> properties = this.getVisibleFromFile(Paths.get(path, visibleProperties));
                        if (!properties.isPresent()) continue;
                        if (!visibleProperties.equals(VISIBLE_PROPERTIES_PATH)) {
                            this.getLog().warn((CharSequence)("Use of " + visibleProperties + " is deprecated. Please use " + VISIBLE_PROPERTIES_PATH));
                        }
                        visible = properties.get();
                        break;
                    }
                    File dir = new File(path);
                    for (File file : dir.listFiles()) {
                        Properties properties = new Properties();
                        if (file.isFile() && file.canRead() && file.getName().endsWith(".properties")) {
                            FileInputStream is = new FileInputStream(file);
                            Object object = null;
                            try {
                                properties.load(is);
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (is != null) {
                                    if (object != null) {
                                        try {
                                            ((InputStream)is).close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        ((InputStream)is).close();
                                    }
                                }
                            }
                        }
                        if (file.isFile() && file.canRead() && (file.getName().endsWith(".yaml") || file.getName().endsWith(".yml"))) {
                            YamlPropertiesFactoryBean yamlPropertiesFactoryBean = new YamlPropertiesFactoryBean();
                            yamlPropertiesFactoryBean.setResources(new Resource[]{new FileSystemResource(file)});
                            properties = yamlPropertiesFactoryBean.getObject();
                        }
                        if (properties.isEmpty()) continue;
                        String functionDefinitions = null;
                        if (properties.containsKey(SPRING_CLOUD_FUNCTION_DEFINITION)) {
                            functionDefinitions = properties.getProperty(SPRING_CLOUD_FUNCTION_DEFINITION);
                        } else if (properties.containsKey(SPRING_CLOUD_STREAM_FUNCTION_DEFINITION)) {
                            functionDefinitions = properties.getProperty(SPRING_CLOUD_STREAM_FUNCTION_DEFINITION);
                        }
                        for (String functionDefinition : StringUtils.delimitedListToStringArray((String)functionDefinitions, (String)";")) {
                            if (functionDefinition == null) continue;
                            for (Object propertyKey : properties.keySet()) {
                                if (((String)propertyKey).startsWith(String.format("%s.%s-in-", SPRING_CLOUD_STREAM_FUNCTION_BINDINGS, functionDefinition))) {
                                    inboundPorts.add(properties.getProperty((String)propertyKey));
                                }
                                if (!((String)propertyKey).startsWith(String.format("%s.%s-out-", SPRING_CLOUD_STREAM_FUNCTION_BINDINGS, functionDefinition))) continue;
                                outboundPorts.add(properties.getProperty((String)propertyKey));
                            }
                        }
                    }
                    continue;
                }
                ZipFile zipFile = new ZipFile(new File(path));
                File[] fileArray = null;
                try {
                    for (String zipEntry : new String[]{VISIBLE_PROPERTIES_PATH, DEPRECATED_WHITELIST_PATH, DEPRECATED_BACKUP_WHITELIST_PATH}) {
                        ZipEntry entry = zipFile.getEntry(zipEntry);
                        if (entry == null) continue;
                        if (!zipEntry.equals(VISIBLE_PROPERTIES_PATH)) {
                            this.getLog().warn((CharSequence)("Use of " + zipEntry + " is deprecated. Please use " + VISIBLE_PROPERTIES_PATH));
                        }
                        visible = this.getVisibleFromZipFile(visible, path, zipFile, entry);
                        continue block20;
                    }
                }
                catch (Throwable object) {
                    fileArray = object;
                    throw object;
                }
                finally {
                    if (zipFile == null) continue;
                    if (fileArray != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable) {
                            fileArray.addSuppressed(throwable);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception trying to read metadata from dependencies of project", e);
        }
        if (!inboundPorts.isEmpty()) {
            visible.put(CONFIGURATION_PROPERTIES_INBOUND_PORTS, StringUtils.arrayToCommaDelimitedString((Object[])inboundPorts.toArray(new String[0])));
        }
        if (!outboundPorts.isEmpty()) {
            visible.put(CONFIGURATION_PROPERTIES_OUTBOUND_PORTS, StringUtils.arrayToCommaDelimitedString((Object[])outboundPorts.toArray(new String[0])));
        }
        return visible;
    }

    ConfigurationMetadata gatherConfigurationMetadata(MetadataFilter metadataFilters) throws MojoExecutionException {
        ConfigurationMetadata metadata = new ConfigurationMetadata();
        try {
            for (String path : this.mavenProject.getRuntimeClasspathElements()) {
                block42: {
                    File file = new File(path);
                    if (file.isDirectory()) {
                        File localMetadata = new File(file, METADATA_PATH);
                        if (localMetadata.canRead()) {
                            try (FileInputStream is = new FileInputStream(localMetadata);){
                                ConfigurationMetadata depMetadata = this.jsonMarshaller.read((InputStream)is);
                                depMetadata = this.filterMetadata(depMetadata, metadataFilters);
                                this.getLog().debug((CharSequence)("Merging metadata from " + path));
                                this.addEnumHints(depMetadata, this.getClassLoader(path));
                                metadata.merge(depMetadata);
                            }
                        }
                    } else {
                        try (ZipFile zipFile = new ZipFile(file);){
                            ZipEntry entry = zipFile.getEntry(METADATA_PATH);
                            if (entry == null) break block42;
                            try (InputStream inputStream = zipFile.getInputStream(entry);){
                                ConfigurationMetadata depMetadata = this.jsonMarshaller.read(inputStream);
                                depMetadata = this.filterMetadata(depMetadata, metadataFilters);
                                this.getLog().debug((CharSequence)("Merging metadata from " + path));
                                this.addEnumHints(depMetadata, this.getClassLoader(path));
                                metadata.merge(depMetadata);
                            }
                        }
                    }
                }
                metadata.getItems().stream().forEach(itemMetadata -> {
                    if (!StringUtils.isEmpty((Object)itemMetadata.getDescription()) && itemMetadata.getDescription().contains("\"")) {
                        itemMetadata.setDescription(itemMetadata.getDescription().replaceAll("\"", "'"));
                    }
                });
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception trying to read metadata from dependencies of project", e);
        }
        return metadata;
    }

    private ConfigurationMetadata filterMetadata(ConfigurationMetadata metadata, MetadataFilter metadataFilters) {
        if (metadataFilters == null || CollectionUtils.isEmpty(metadataFilters.getNames()) && CollectionUtils.isEmpty(metadataFilters.getSourceTypes())) {
            return metadata;
        }
        List<String> sourceTypeFilters = CollectionUtils.isEmpty(metadataFilters.getSourceTypes()) ? Collections.EMPTY_LIST : metadataFilters.getSourceTypes();
        List<String> nameFilters = CollectionUtils.isEmpty(metadataFilters.getNames()) ? Collections.EMPTY_LIST : metadataFilters.getNames();
        ConfigurationMetadata filteredMetadata = new ConfigurationMetadata();
        ArrayList<String> visibleNames = new ArrayList<String>();
        for (ItemMetadata itemMetadata : metadata.getItems()) {
            String metadataName = itemMetadata.getName();
            String metadataSourceType = itemMetadata.getSourceType();
            if (StringUtils.hasText((String)metadataSourceType) && sourceTypeFilters.contains(metadataSourceType.trim())) {
                filteredMetadata.add(itemMetadata);
                visibleNames.add(itemMetadata.getName());
            }
            if (!StringUtils.hasText((String)metadataName) || !nameFilters.contains(metadataName.trim())) continue;
            filteredMetadata.add(itemMetadata);
            visibleNames.add(itemMetadata.getName());
        }
        for (ItemHint itemHint : metadata.getHints()) {
            if (itemHint == null || !visibleNames.contains(itemHint.getName())) continue;
            filteredMetadata.add(itemHint);
        }
        return filteredMetadata;
    }

    private Properties getVisibleFromZipFile(Properties visible, String path, ZipFile zipFile, ZipEntry entry) throws IOException {
        try (InputStream inputStream = zipFile.getInputStream(entry);){
            this.getLog().debug((CharSequence)("Merging visible metadata from " + path));
            visible = this.merge(visible, inputStream);
        }
        return visible;
    }

    private Optional<Properties> getVisibleFromFile(Path visiblePropertiesPath) throws IOException {
        File localVisible = visiblePropertiesPath.toFile();
        if (localVisible.canRead()) {
            Properties visible = new Properties();
            try (FileInputStream is = new FileInputStream(localVisible);){
                this.getLog().debug((CharSequence)("!!!! Merging visible metadata from " + visiblePropertiesPath.toString()));
                visible = this.merge(visible, is);
                Optional<Properties> optional = Optional.of(visible);
                return optional;
            }
        }
        return Optional.empty();
    }

    Properties merge(Properties visible, InputStream is) throws IOException {
        Properties mergedProperties = new Properties();
        mergedProperties.load(is);
        if (!mergedProperties.containsKey(CONFIGURATION_PROPERTIES_CLASSES) && !mergedProperties.containsKey(CONFIGURATION_PROPERTIES_NAMES)) {
            this.getLog().warn((CharSequence)String.format("Visible properties does not contain any required keys: %s", StringUtils.arrayToCommaDelimitedString((Object[])new String[]{CONFIGURATION_PROPERTIES_CLASSES, CONFIGURATION_PROPERTIES_NAMES})));
            return visible;
        }
        if (!CollectionUtils.isEmpty((Map)visible)) {
            this.mergeCommaDelimitedValue(visible, mergedProperties, CONFIGURATION_PROPERTIES_CLASSES);
            this.mergeCommaDelimitedValue(visible, mergedProperties, CONFIGURATION_PROPERTIES_NAMES);
        }
        return mergedProperties;
    }

    private void mergeCommaDelimitedValue(Properties currentProperties, Properties newProperties, String key) {
        if (currentProperties.containsKey(key) || newProperties.containsKey(key)) {
            Set values = StringUtils.commaDelimitedListToSet((String)currentProperties.getProperty(key));
            values.addAll(StringUtils.commaDelimitedListToSet((String)newProperties.getProperty(key)));
            if (newProperties.containsKey(key)) {
                this.getLog().debug((CharSequence)String.format("Merging visible property %s=%s", key, newProperties.getProperty(key)));
            }
            newProperties.setProperty(key, StringUtils.collectionToCommaDelimitedString((Collection)values));
        }
    }

    void produceArtifact(Result result) throws MojoExecutionException {
        String artifactLocation = String.format("target/%s-%s-%s.jar", this.mavenProject.getArtifactId(), this.mavenProject.getVersion(), this.classifier);
        File output = new File(this.mavenProject.getBasedir(), artifactLocation);
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(output));){
            ZipEntry entry = new ZipEntry(METADATA_PATH);
            jos.putNextEntry(entry);
            this.jsonMarshaller.write(result.metadata, (OutputStream)jos);
            entry = new ZipEntry(VISIBLE_PROPERTIES_PATH);
            jos.putNextEntry(entry);
            result.visible.store(jos, "Describes visible properties for this app");
            entry = new ZipEntry(DEPRECATED_WHITELIST_PATH);
            jos.putNextEntry(entry);
            result.visible.store(jos, "DEPRECATED: Describes visible properties for this app");
            entry = new ZipEntry(DEPRECATED_BACKUP_WHITELIST_PATH);
            jos.putNextEntry(entry);
            result.visible.store(jos, "DEPRECATED: Describes visible properties for this app");
            entry = new ZipEntry("META-INF/dataflow-configuration-port-mapping.properties");
            jos.putNextEntry(entry);
            entry = new ZipEntry("META-INF/dataflow-configuration-option-groups.properties");
            jos.putNextEntry(entry);
            result.getPortMappingProperties().store(jos, "Describes visible port mapping properties for this app");
            this.getLog().info((CharSequence)String.format("Attaching %s to current project", output.getCanonicalPath()));
            this.projectHelper.attachArtifact(this.mavenProject, output, this.classifier);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing to file", (Exception)e);
        }
    }

    void addEnumHints(ConfigurationMetadata configurationMetadata, ClassLoader classLoader) {
        HashMap providers = new HashMap();
        HashMap<String, ItemHint> itemHints = new HashMap<String, ItemHint>();
        for (ItemMetadata property : configurationMetadata.getItems()) {
            Class clazz;
            if (!property.isOfItemType(ItemMetadata.ItemType.PROPERTY) || !ClassUtils.isPresent((String)property.getType(), (ClassLoader)classLoader) || !(clazz = ClassUtils.resolveClassName((String)property.getType(), (ClassLoader)classLoader)).isEnum()) continue;
            ArrayList<ItemHint.ValueHint> valueHints = new ArrayList<ItemHint.ValueHint>();
            for (Object o : clazz.getEnumConstants()) {
                valueHints.add(new ItemHint.ValueHint(o, null));
            }
            if (!providers.containsKey(property.getType())) {
                providers.put(property.getType(), new ArrayList());
            }
            boolean found = false;
            for (ItemHint.ValueProvider valueProvider : (List)providers.get(property.getType())) {
                if (!valueProvider.getName().equals(property.getType())) continue;
                found = true;
            }
            if (!found) {
                ((List)providers.get(property.getType())).add(new ItemHint.ValueProvider(property.getType(), null));
            }
            itemHints.put(property.getType(), new ItemHint(property.getName(), valueHints, new ArrayList((Collection)providers.get(property.getType()))));
        }
        if (!CollectionUtils.isEmpty(itemHints)) {
            for (ItemHint itemHint : itemHints.values()) {
                configurationMetadata.add(itemHint);
            }
        }
    }

    private ClassLoader getClassLoader(String jarPath) {
        URLClassLoader classLoader = null;
        try {
            classLoader = new URLClassLoader(new URL[]{new URL("file://" + jarPath)}, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return classLoader;
    }

    static final class Result {
        private final ConfigurationMetadata metadata;
        private final Properties visible;

        private Properties getPortMappingProperties() {
            Properties portMappingProperties = new Properties();
            this.visible.entrySet().stream().filter(e -> e.getKey().equals(MetadataAggregationMojo.CONFIGURATION_PROPERTIES_OUTBOUND_PORTS) || e.getKey().equals(MetadataAggregationMojo.CONFIGURATION_PROPERTIES_INBOUND_PORTS)).forEach(e -> portMappingProperties.put(e.getKey(), e.getValue()));
            return portMappingProperties;
        }

        private Result(ConfigurationMetadata metadata, Properties visible) {
            this.metadata = metadata;
            this.visible = visible;
        }
    }

    public static class MetadataFilter {
        private List<String> names;
        private List<String> sourceTypes;

        public List<String> getNames() {
            return this.names;
        }

        public void setNames(List<String> names) {
            this.names = names;
        }

        public List<String> getSourceTypes() {
            return this.sourceTypes;
        }

        public void setSourceTypes(List<String> sourceTypes) {
            this.sourceTypes = sourceTypes;
        }

        public String toString() {
            return "MetadataFilter{name=" + this.names + ", sourceType=" + this.sourceTypes + '}';
        }
    }
}

