/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.builder.Acceptor;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.CustomModeBodyParser;
import org.springframework.cloud.contract.verifier.builder.CustomModeGiven;
import org.springframework.cloud.contract.verifier.builder.CustomModeThen;
import org.springframework.cloud.contract.verifier.builder.CustomModeWhen;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.JavaJaxRsThen;
import org.springframework.cloud.contract.verifier.builder.JavaJaxRsWhen;
import org.springframework.cloud.contract.verifier.builder.JavaMessagingWithBodyThen;
import org.springframework.cloud.contract.verifier.builder.JavaRestAssuredGiven;
import org.springframework.cloud.contract.verifier.builder.JavaRestAssuredThen;
import org.springframework.cloud.contract.verifier.builder.JavaRestAssuredWhen;
import org.springframework.cloud.contract.verifier.builder.JaxRsGiven;
import org.springframework.cloud.contract.verifier.builder.MessagingWhen;
import org.springframework.cloud.contract.verifier.builder.MethodAnnotationBuilder;
import org.springframework.cloud.contract.verifier.builder.MethodAnnotations;
import org.springframework.cloud.contract.verifier.builder.MethodMetadata;
import org.springframework.cloud.contract.verifier.builder.MethodMetadataBuilder;
import org.springframework.cloud.contract.verifier.builder.MethodPostProcessor;
import org.springframework.cloud.contract.verifier.builder.MethodPreProcessor;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.SpockJaxRsThen;
import org.springframework.cloud.contract.verifier.builder.SpockJaxRsWhen;
import org.springframework.cloud.contract.verifier.builder.SpockMessagingEmptyThen;
import org.springframework.cloud.contract.verifier.builder.SpockMessagingWithBodyThen;
import org.springframework.cloud.contract.verifier.builder.SpockRestAssuredGiven;
import org.springframework.cloud.contract.verifier.builder.SpockRestAssuredThen;
import org.springframework.cloud.contract.verifier.builder.SpockRestAssuredWhen;
import org.springframework.cloud.contract.verifier.builder.TemplateUpdatingMethodPostProcessor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class SingleMethodBuilder {
    private static final Log log = LogFactory.getLog(SingleMethodBuilder.class);
    private List<MethodAnnotations> methodAnnotations = new LinkedList<MethodAnnotations>();
    private List<MethodMetadata> methodMetadata = new LinkedList<MethodMetadata>();
    private List<MethodPreProcessor> methodPreProcessors = new LinkedList<MethodPreProcessor>();
    private List<MethodPostProcessor> methodPostProcessors = new LinkedList<MethodPostProcessor>();
    private List<Given> givens = new LinkedList<Given>();
    private List<When> whens = new LinkedList<When>();
    private List<Then> thens = new LinkedList<Then>();
    final GeneratedClassMetaData generatedClassMetaData;
    final BlockBuilder blockBuilder;

    private SingleMethodBuilder(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    static SingleMethodBuilder builder(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        return new SingleMethodBuilder(blockBuilder, generatedClassMetaData);
    }

    SingleMethodBuilder methodAnnotation(MethodAnnotations methodAnnotations) {
        this.methodAnnotations.add(methodAnnotations);
        return this;
    }

    MethodAnnotationBuilder methodAnnotation() {
        return new MethodAnnotationBuilder(this);
    }

    SingleMethodBuilder methodAnnotation(MethodAnnotations ... methodAnnotations) {
        this.methodAnnotations.addAll(Arrays.asList(methodAnnotations));
        return this;
    }

    MethodMetadataBuilder methodMetadata() {
        return new MethodMetadataBuilder(this);
    }

    SingleMethodBuilder methodMetadata(MethodMetadata ... methodMetadata) {
        this.methodMetadata.addAll(Arrays.asList(methodMetadata));
        return this;
    }

    SingleMethodBuilder restAssured() {
        return this.given(new JavaRestAssuredGiven(this.blockBuilder, this.generatedClassMetaData)).given(new SpockRestAssuredGiven(this.blockBuilder, this.generatedClassMetaData)).when(new JavaRestAssuredWhen(this.blockBuilder, this.generatedClassMetaData)).when(new SpockRestAssuredWhen(this.blockBuilder, this.generatedClassMetaData)).then(new JavaRestAssuredThen(this.blockBuilder, this.generatedClassMetaData)).then(new SpockRestAssuredThen(this.blockBuilder, this.generatedClassMetaData)).methodPostProcessor(new TemplateUpdatingMethodPostProcessor(this.blockBuilder));
    }

    SingleMethodBuilder customMode() {
        return this.given(new CustomModeGiven(this.blockBuilder, this.generatedClassMetaData, CustomModeBodyParser.INSTANCE)).when(new CustomModeWhen(this.blockBuilder, this.generatedClassMetaData)).then(new CustomModeThen(this.blockBuilder, this.generatedClassMetaData, CustomModeBodyParser.INSTANCE, ComparisonBuilder.JAVA_HTTP_INSTANCE)).methodPostProcessor(new TemplateUpdatingMethodPostProcessor(this.blockBuilder));
    }

    SingleMethodBuilder jaxRs() {
        return this.given(new JaxRsGiven(this.generatedClassMetaData)).when(new JavaJaxRsWhen(this.blockBuilder, this.generatedClassMetaData)).when(new SpockJaxRsWhen(this.blockBuilder, this.generatedClassMetaData)).then(new JavaJaxRsThen(this.blockBuilder, this.generatedClassMetaData)).then(new SpockJaxRsThen(this.blockBuilder, this.generatedClassMetaData)).methodPostProcessor(new TemplateUpdatingMethodPostProcessor(this.blockBuilder));
    }

    SingleMethodBuilder messaging() {
        return this.when(new MessagingWhen(this.blockBuilder)).then(new JavaMessagingWithBodyThen(this.blockBuilder, this.generatedClassMetaData)).then(new SpockMessagingWithBodyThen(this.blockBuilder, this.generatedClassMetaData)).then(new SpockMessagingEmptyThen(this.blockBuilder, this.generatedClassMetaData)).methodPostProcessor(new TemplateUpdatingMethodPostProcessor(this.blockBuilder));
    }

    SingleMethodBuilder given(Given ... given) {
        this.givens.addAll(Arrays.asList(given));
        return this;
    }

    SingleMethodBuilder when(When ... when) {
        this.whens.addAll(Arrays.asList(when));
        return this;
    }

    SingleMethodBuilder then(Then ... then) {
        this.thens.addAll(Arrays.asList(then));
        return this;
    }

    SingleMethodBuilder methodPreProcessor(MethodPreProcessor methodPreProcessor) {
        this.methodPreProcessors.add(methodPreProcessor);
        return this;
    }

    SingleMethodBuilder methodPostProcessor(MethodPostProcessor methodPostProcessor) {
        this.methodPostProcessors.add(methodPostProcessor);
        return this;
    }

    BlockBuilder build() {
        MethodMetadata methodMetadatum = this.pickMetadatum();
        this.blockBuilder.addEmptyLine();
        this.generatedClassMetaData.toSingleContractMetadata().forEach(metaData -> {
            boolean stopProcessing = this.shouldStopProcessing((SingleContractMetadata)metaData);
            if (stopProcessing) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The method for meta data [" + String.valueOf(metaData) + "] will not be processed further. At least one method pre-processor declared that this method should be skipped."));
                }
                return;
            }
            if (this.visit((List<? extends MethodVisitor>)this.methodAnnotations, (SingleContractMetadata)metaData, false)) {
                this.blockBuilder.addEmptyLine();
            }
            this.blockBuilder.append(methodMetadatum::modifier).appendWithSpace(methodMetadatum::returnType).appendWithSpace(() -> methodMetadatum.name((SingleContractMetadata)metaData)).append("() throws Exception ");
            this.blockBuilder.inBraces(() -> {
                if (this.visit((List<? extends MethodVisitor>)this.givens, (SingleContractMetadata)metaData)) {
                    this.blockBuilder.addEmptyLine();
                }
                this.visit((List<? extends MethodVisitor>)this.whens, (SingleContractMetadata)metaData);
                this.blockBuilder.addEmptyLine();
                this.visit((List<? extends MethodVisitor>)this.thens, (SingleContractMetadata)metaData);
            });
            this.blockBuilder.addEmptyLine();
            this.methodPostProcessors.stream().filter(m -> m.accept((SingleContractMetadata)metaData)).forEach(m -> m.apply(metaData));
        });
        return this.blockBuilder;
    }

    private boolean shouldStopProcessing(SingleContractMetadata metaData) {
        List matchingPreProcessors = this.methodPreProcessors.stream().filter(m -> m.accept(metaData)).collect(Collectors.toCollection(LinkedList::new));
        matchingPreProcessors.forEach(m -> m.apply(metaData));
        return matchingPreProcessors.stream().anyMatch(m -> !m.shouldContinue());
    }

    private MethodMetadata pickMetadatum() {
        return this.methodMetadata.stream().filter(Acceptor::accept).findFirst().orElseThrow(() -> new IllegalStateException("No matching method metadata found"));
    }

    private boolean visit(List<? extends MethodVisitor> list, SingleContractMetadata metaData) {
        return this.visit(list, metaData, true);
    }

    private boolean visit(List<? extends MethodVisitor> list, SingleContractMetadata metaData, boolean addLineEnding) {
        List visitors = list.stream().filter(o -> o.accept(metaData)).collect(Collectors.toList());
        Iterator iterator = visitors.iterator();
        while (iterator.hasNext()) {
            MethodVisitor visitor = (MethodVisitor)iterator.next();
            visitor.apply(metaData);
            if (addLineEnding) {
                this.blockBuilder.addEndingIfNotPresent();
            }
            if (!iterator.hasNext()) continue;
            this.blockBuilder.addEmptyLine();
        }
        return !visitors.isEmpty();
    }
}

