/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GString;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.verifier.template.HandlebarsTemplateProcessor;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.ContentUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.json.JsonMapper;

public class MapConverter {
    private static final boolean STUB_SIDE = true;
    private static final boolean TEST_SIDE = false;
    public static final Function<String, Object> JSON_PARSING_FUNCTION = value -> {
        try {
            return new JsonMapper().readValue(value, Object.class);
        }
        catch (JacksonException e) {
            throw new IllegalArgumentException("The current json [" + value + "] could not be deserialized");
        }
    };
    public static final Closure<Object> JSON_PARSING_CLOSURE = new Closure<Object>(null){

        public Object doCall(Object it) {
            return new JsonSlurper().parseText((String)it);
        }
    };
    public static final Function<String, Object> IDENTITY = value -> value;
    private final TemplateProcessor templateProcessor = this.processor();

    MapConverter() {
    }

    private TemplateProcessor processor() {
        return new HandlebarsTemplateProcessor();
    }

    public static Object transformToClientValues(Object value) {
        return MapConverter.transformValues(value, v -> v instanceof DslProperty ? ((DslProperty)v).getClientValue() : v);
    }

    public static Object transformValues(Object value, Function<Object, ?> function) {
        return MapConverter.transformValues(value, function, JSON_PARSING_FUNCTION);
    }

    public static Object transformValues(Object value, Function<Object, ?> function, Function<String, Object> parsingFunction) {
        if (value instanceof String) {
            try {
                Object parsed = parsingFunction.apply((String)value);
                if (parsed instanceof Map) {
                    return MapConverter.convert((Map)parsed, function, parsingFunction);
                }
                if (parsed instanceof List) {
                    return MapConverter.transformValues(parsed, function, parsingFunction);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return MapConverter.extractValue(value, function);
        }
        if (value instanceof Map) {
            return MapConverter.convert((Map)value, function, parsingFunction);
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(v -> MapConverter.transformValues(v, function, parsingFunction)).collect(Collectors.toList());
        }
        return MapConverter.transformValue(function, value, parsingFunction);
    }

    protected static Object transformValue(Function<Object, ?> function, Object value, Function<String, Object> parsingFunction) {
        return MapConverter.extractValue(value, val -> {
            Object newValue = function.apply(val);
            if (newValue instanceof Map || newValue instanceof List || newValue instanceof String && val != null) {
                return MapConverter.transformValues(newValue, function, parsingFunction);
            }
            return newValue;
        });
    }

    private static Object extractValue(Object value, Function<Object, ?> function) {
        try {
            return function.apply(value);
        }
        catch (Exception ignore) {
            return value;
        }
    }

    private static Map<?, ?> convert(Map<?, ?> map, Function<Object, ?> function, Function<String, Object> parsingFunction) {
        LinkedHashMap convertedMap = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            convertedMap.put(entry.getKey(), MapConverter.transformValues(entry.getValue(), function, parsingFunction));
        }
        return convertedMap;
    }

    public static Object getClientOrServerSideValues(Object json, boolean clientSide) {
        return MapConverter.getClientOrServerSideValues(json, clientSide, JSON_PARSING_FUNCTION);
    }

    public static Object getClientOrServerSideValues(Object json, boolean clientSide, Function<String, Object> parsingFunction) {
        return MapConverter.transformValues(json, val -> {
            if (val instanceof DslProperty) {
                DslProperty dslProperty = (DslProperty)val;
                return clientSide ? MapConverter.getClientOrServerSideValues(dslProperty.getClientValue(), clientSide, parsingFunction) : MapConverter.getClientOrServerSideValues(dslProperty.getServerValue(), clientSide, parsingFunction);
            }
            if (val instanceof GString) {
                ContentType type = new MapConverter().templateProcessor.containsJsonPathTemplateEntry(ContentUtils.extractValueForGString((GString)val, ContentUtils.GET_TEST_SIDE).toString()) ? ContentType.TEXT : null;
                return ContentUtils.extractValue((GString)val, type, v -> {
                    if (v instanceof DslProperty) {
                        return clientSide ? MapConverter.getClientOrServerSideValues(((DslProperty)v).getClientValue(), clientSide, parsingFunction) : MapConverter.getClientOrServerSideValues(((DslProperty)v).getServerValue(), clientSide, parsingFunction);
                    }
                    return v;
                });
            }
            if (val instanceof FromFileProperty) {
                return ((FromFileProperty)val).isByte() ? ((FromFileProperty)val).asBytes() : (byte[])((FromFileProperty)val).asString();
            }
            return val;
        }, parsingFunction);
    }

    public static Object getStubSideValues(Object json) {
        return MapConverter.getClientOrServerSideValues(json, true, JSON_PARSING_FUNCTION);
    }

    public static Object getStubSideValues(Object json, Function<String, Object> parsingClosure) {
        return MapConverter.getClientOrServerSideValues(json, true, parsingClosure);
    }

    public static Object getTestSideValues(Object json) {
        return MapConverter.getTestSideValues(json, JSON_PARSING_FUNCTION);
    }

    public static Object getTestSideValues(Object json, Function<String, Object> parsingClosure) {
        return MapConverter.getClientOrServerSideValues(json, false, parsingClosure);
    }

    public static Object getTestSideValuesForText(Object json) {
        return MapConverter.getClientOrServerSideValues(json, false, IDENTITY);
    }

    public static Object getStubSideValuesForNonBody(Object object) {
        return MapConverter.getClientOrServerSideValues(object, true, IDENTITY);
    }

    public static Object getTestSideValuesForNonBody(Object object) {
        return MapConverter.getClientOrServerSideValues(object, false, IDENTITY);
    }
}

