/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.BodyReader;
import org.springframework.cloud.contract.verifier.builder.CommunicationType;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;

class CustomModeBodyGiven
implements Given {
    private final BlockBuilder blockBuilder;
    private final BodyReader bodyReader;
    private final BodyParser bodyParser;

    CustomModeBodyGiven(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.bodyReader = new BodyReader(generatedClassMetaData);
        this.bodyParser = bodyParser;
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata metadata) {
        this.processInput(this.blockBuilder, metadata);
        return this;
    }

    private void processInput(BlockBuilder bb, SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        Object serverValue = request.getBody().getServerValue();
        Object body = serverValue instanceof ExecutionProperty || serverValue instanceof FromFileProperty ? request.getBody().getServerValue() : this.bodyParser.requestBodyAsString(metadata);
        bb.addIndented(this.getBodyString(metadata, body));
    }

    private String getBodyString(SingleContractMetadata metadata, Object body) {
        String value;
        if (body instanceof ExecutionProperty) {
            value = body.toString();
        } else if (body instanceof FromFileProperty) {
            FromFileProperty fileProperty = (FromFileProperty)body;
            value = fileProperty.isByte() ? this.bodyReader.readBytesFromFileString(metadata, fileProperty, CommunicationType.REQUEST) : this.bodyReader.readStringFromFileString(metadata, fileProperty, CommunicationType.REQUEST);
        } else {
            String escaped = this.escapeRequestSpecialChars(metadata, body.toString());
            value = this.bodyParser.quotedEscapedLongText(escaped);
        }
        return ".body(" + value + ")";
    }

    private String escapeRequestSpecialChars(SingleContractMetadata metadata, String string) {
        if (metadata.getInputTestContentType() == ContentType.JSON) {
            return string.replaceAll("\\\\n", "\\\\\\\\n");
        }
        return string;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        return request != null && request.getBody() != null;
    }
}

