/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.internal;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessage;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessageMetadata;

public class ContractVerifierMessaging<M> {
    private static final Log log = LogFactory.getLog(ContractVerifierMessaging.class);
    private final MessageVerifierSender<M> sender;
    private final MessageVerifierReceiver<M> receiver;

    public ContractVerifierMessaging(MessageVerifierSender<M> sender, MessageVerifierReceiver<M> receiver) {
        this.sender = sender;
        this.receiver = receiver;
        if (sender != null) {
            log.info((Object)("The message verifier sender implementation is of type [" + sender.getClass() + "]"));
        }
        if (receiver != null) {
            log.info((Object)("The message verifier receiver implementation is of type [" + receiver.getClass() + "]"));
        }
    }

    public void send(ContractVerifierMessage message, String destination, @Nullable YamlContract contract) {
        if (contract != null) {
            this.setMessageType(contract, ContractVerifierMessageMetadata.MessageType.INPUT);
        }
        this.sender.send(message.getPayload(), message.getHeaders(), destination, contract);
    }

    public void send(ContractVerifierMessage message, String destination) {
        this.send(message, destination, null);
    }

    public ContractVerifierMessage receive(String destination, @Nullable YamlContract contract) {
        if (contract != null) {
            this.setMessageType(contract, ContractVerifierMessageMetadata.MessageType.OUTPUT);
        }
        return this.convert(this.receiver.receive(destination, contract));
    }

    private void setMessageType(YamlContract contract, ContractVerifierMessageMetadata.MessageType output) {
        contract.metadata.put("verifierMessage", new ContractVerifierMessageMetadata(output));
    }

    public ContractVerifierMessage receive(String destination) {
        return this.receive(destination, null);
    }

    public <T> ContractVerifierMessage create(T payload, Map<String, Object> headers) {
        return new ContractVerifierMessage(payload, headers);
    }

    protected ContractVerifierMessage convert(M receive) {
        return new ContractVerifierMessage(receive, null);
    }
}

