/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.jms;

import jakarta.jms.Message;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.integration.ContractVerifierIntegrationConfiguration;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.jms.ContractVerifierJmsHelper;
import org.springframework.cloud.contract.verifier.messaging.jms.JmsStubMessages;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JmsTemplate.class})
@ConditionalOnProperty(name={"stubrunner.jms.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={ContractVerifierIntegrationConfiguration.class, NoOpContractVerifierAutoConfiguration.class})
public class ContractVerifierJmsConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MessageVerifierSender.class})
    MessageVerifierSender<Message> contractVerifierJmsMessageSender(ObjectProvider<JmsTemplate> jmsTemplateProvider) {
        JmsTemplate jmsTemplate = (JmsTemplate)jmsTemplateProvider.getIfAvailable(JmsTemplate::new);
        final JmsStubMessages jmsStubMessages = new JmsStubMessages(jmsTemplate);
        return new MessageVerifierSender<Message>(){

            @Override
            public void send(Message message, String destination, @Nullable YamlContract contract) {
                jmsStubMessages.send(message, destination, contract);
            }

            @Override
            public <T> void send(T payload, Map<String, Object> headers, String destination, @Nullable YamlContract contract) {
                jmsStubMessages.send((Object)payload, (Map)headers, destination, contract);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageVerifierReceiver.class})
    MessageVerifierReceiver<Message> contractVerifierJmsMessageReceiver(ObjectProvider<JmsTemplate> jmsTemplateProvider) {
        JmsTemplate jmsTemplate = (JmsTemplate)jmsTemplateProvider.getIfAvailable(JmsTemplate::new);
        final JmsStubMessages jmsStubMessages = new JmsStubMessages(jmsTemplate);
        return new MessageVerifierReceiver<Message>(){

            @Override
            public Message receive(String destination, long timeout, TimeUnit timeUnit, @Nullable YamlContract contract) {
                return jmsStubMessages.receive(destination, timeout, timeUnit, contract);
            }

            @Override
            public Message receive(String destination, YamlContract contract) {
                return jmsStubMessages.receive(destination, contract);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={ContractVerifierMessaging.class})
    ContractVerifierMessaging<Message> contractVerifierJmsMessaging(MessageVerifierSender<Message> sender, MessageVerifierReceiver<Message> receiver) {
        return new ContractVerifierJmsHelper(sender, receiver);
    }
}

