/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.verifier.builder.SingleTestGenerator;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class GeneratedClassMetaData {
    final ContractVerifierConfigProperties configProperties;
    final Collection<ContractMetadata> listOfFiles;
    final String includedDirectoryRelativePath;
    final SingleTestGenerator.GeneratedClassData generatedClassData;

    GeneratedClassMetaData(ContractVerifierConfigProperties configProperties, Collection<ContractMetadata> listOfFiles, String includedDirectoryRelativePath, SingleTestGenerator.GeneratedClassData generatedClassData) {
        this.configProperties = configProperties;
        this.listOfFiles = listOfFiles;
        this.includedDirectoryRelativePath = includedDirectoryRelativePath;
        this.generatedClassData = generatedClassData;
    }

    Collection<SingleContractMetadata> toSingleContractMetadata() {
        return this.listOfFiles.stream().flatMap(metadata -> metadata.getConvertedContractWithMetadata().stream()).collect(Collectors.toList());
    }

    boolean isAnyJson() {
        return this.toSingleContractMetadata().stream().anyMatch(SingleContractMetadata::isJson);
    }

    boolean isAnyIgnored() {
        return this.toSingleContractMetadata().stream().anyMatch(SingleContractMetadata::isIgnored);
    }

    boolean isAnyXml() {
        return this.toSingleContractMetadata().stream().anyMatch(SingleContractMetadata::isXml);
    }

    boolean isAnyHttp() {
        return this.toSingleContractMetadata().stream().anyMatch(SingleContractMetadata::isHttp);
    }

    boolean isAnyMessaging() {
        return this.toSingleContractMetadata().stream().anyMatch(SingleContractMetadata::isMessaging);
    }
}

