/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.internal;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessage;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessageMetadata;

public class ContractVerifierMessaging<M> {
    private static final Log log = LogFactory.getLog(ContractVerifierMessaging.class);
    private final MessageVerifier<M> exchange;

    public ContractVerifierMessaging(MessageVerifier<M> exchange) {
        this.exchange = exchange;
        if (exchange != null) {
            log.info((Object)("The message verifier implementation is of type [" + exchange.getClass() + "]"));
        }
    }

    public void send(ContractVerifierMessage message, String destination, @Nullable YamlContract contract) {
        if (contract != null) {
            this.setMessageType(contract, ContractVerifierMessageMetadata.MessageType.INPUT);
        }
        this.exchange.send(message.getPayload(), message.getHeaders(), destination, contract);
    }

    public void send(ContractVerifierMessage message, String destination) {
        this.send(message, destination, null);
    }

    public ContractVerifierMessage receive(String destination, @Nullable YamlContract contract) {
        if (contract != null) {
            this.setMessageType(contract, ContractVerifierMessageMetadata.MessageType.OUTPUT);
        }
        return this.convert(this.exchange.receive(destination, contract));
    }

    private void setMessageType(YamlContract contract, ContractVerifierMessageMetadata.MessageType output) {
        contract.metadata.put("verifierMessage", new ContractVerifierMessageMetadata(output));
    }

    public ContractVerifierMessage receive(String destination) {
        return this.receive(destination, null);
    }

    public <T> ContractVerifierMessage create(T payload, Map<String, Object> headers) {
        return new ContractVerifierMessage(payload, headers);
    }

    protected ContractVerifierMessage convert(M receive) {
        return new ContractVerifierMessage(receive, null);
    }
}

