/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.jms;

import javax.jms.Message;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.integration.ContractVerifierIntegrationConfiguration;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.jms.ContractVerifierJmsHelper;
import org.springframework.cloud.contract.verifier.messaging.jms.JmsStubMessages;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={JmsTemplate.class})
@ConditionalOnProperty(name={"stubrunner.jms.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={ContractVerifierIntegrationConfiguration.class, NoOpContractVerifierAutoConfiguration.class})
public class ContractVerifierJmsConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MessageVerifier<Message> contractVerifierJmsMessageExchange(ObjectProvider<JmsTemplate> jmsTemplateProvider) {
        JmsTemplate jmsTemplate = (JmsTemplate)jmsTemplateProvider.getIfAvailable(JmsTemplate::new);
        return new JmsStubMessages(jmsTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    ContractVerifierMessaging<Message> contractVerifierJmsMessaging(MessageVerifier<Message> exchange) {
        return new ContractVerifierJmsHelper(exchange);
    }
}

