/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.file;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

public class ContractMetadata {
    private final Path path;
    private final boolean ignored;
    private final int groupSize;
    private final Integer order;
    private final List<Contract> convertedContract = new ArrayList<Contract>();
    private final Collection<SingleContractMetadata> convertedContractWithMetadata = new ArrayList<SingleContractMetadata>();

    public ContractMetadata(Path path, boolean ignored, int groupSize, Integer order, Contract convertedContract) {
        this(path, ignored, groupSize, order, Collections.singletonList(convertedContract));
    }

    public ContractMetadata(Path path, boolean ignored, int groupSize, Integer order, Collection<Contract> convertedContract) {
        this.groupSize = groupSize;
        this.path = path;
        this.ignored = ignored;
        this.order = order;
        this.convertedContract.addAll(convertedContract);
        this.convertedContractWithMetadata.addAll(this.convertedContract.stream().filter(Objects::nonNull).map(it -> new SingleContractMetadata((Contract)it, this)).collect(Collectors.toList()));
    }

    public SingleContractMetadata forContract(Contract contract) {
        return this.convertedContractWithMetadata.stream().filter(it -> it.getContract().equals((Object)contract)).findFirst().orElse(null);
    }

    public boolean anyInProgress() {
        return this.convertedContract.stream().anyMatch(Contract::getInProgress);
    }

    public Path getPath() {
        return this.path;
    }

    public boolean getIgnored() {
        return this.ignored;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public Integer getOrder() {
        return this.order;
    }

    public List<Contract> getConvertedContract() {
        return this.convertedContract;
    }

    public Collection<SingleContractMetadata> getConvertedContractWithMetadata() {
        return this.convertedContractWithMetadata;
    }
}

