/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.jms;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessage;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;

class ContractVerifierJmsHelper
extends ContractVerifierMessaging<Message> {
    private static final Log log = LogFactory.getLog(ContractVerifierJmsHelper.class);

    ContractVerifierJmsHelper(MessageVerifier<Message> exchange) {
        super(exchange);
    }

    @Override
    protected ContractVerifierMessage convert(Message message) {
        try {
            Map<String, Object> headers = this.headers(message);
            return new ContractVerifierMessage(this.getPayload(message), headers);
        }
        catch (JMSException ex) {
            log.warn((Object)"An exception occurred while trying to convert the JMS message", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    private Map<String, Object> headers(Message message) throws JMSException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (message == null) {
            return headers;
        }
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            String asString = element.toString();
            Object property = message.getObjectProperty(asString);
            headers.put(asString, property);
        }
        return headers;
    }

    private Object getPayload(Message message) throws JMSException {
        if (message == null) {
            return null;
        }
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText();
        }
        if (message instanceof StreamMessage) {
            return ((StreamMessage)message).readObject();
        }
        if (message instanceof ObjectMessage) {
            return ((ObjectMessage)message).getObject();
        }
        return message.getBody(Object.class);
    }
}

