/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ContentHelper;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class MockMvcHeadersGiven
implements Given {
    private final BlockBuilder blockBuilder;

    MockMvcHeadersGiven(BlockBuilder blockBuilder) {
        this.blockBuilder = blockBuilder;
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata metadata) {
        this.processInput(this.blockBuilder, metadata.getContract().getRequest().getHeaders());
        return this;
    }

    private void processInput(BlockBuilder bb, Headers headers) {
        Iterator iterator = headers.getEntries().iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            if (this.ofAbsentType(header)) {
                return;
            }
            if (iterator.hasNext()) {
                bb.addLine(this.string(header));
                continue;
            }
            bb.addIndented(this.string(header));
        }
    }

    private String string(Header header) {
        return ".header(" + ContentHelper.getTestSideForNonBodyValue(header.getName()) + ", " + ContentHelper.getTestSideForNonBodyValue(MapConverter.getTestSideValuesForNonBody(header.getServerValue())) + ")";
    }

    private boolean ofAbsentType(Header header) {
        return header.getServerValue() instanceof MatchingStrategy && MatchingStrategy.Type.ABSENT.equals((Object)((MatchingStrategy)header.getServerValue()).getType());
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        return request != null && request.getHeaders() != null;
    }
}

