/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import com.toomuchcoding.jsonassert.JsonVerifiable;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.verifier.util.FinishedDelegatingJsonVerifiable;
import org.springframework.cloud.contract.verifier.util.MethodBufferingJsonVerifiable;
import org.springframework.cloud.contract.verifier.util.ShouldTraverse;

class DelegatingJsonVerifiable
implements MethodBufferingJsonVerifiable {
    private static final Log log = LogFactory.getLog(DelegatingJsonVerifiable.class);
    private static final Pattern FIELD_PATTERN = Pattern.compile("\\.field\\((\")?(.)+(\")?\\)");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\.array\\((\")?(.)+(\")?\\)");
    final JsonVerifiable delegate;
    final LinkedList<String> methodsBuffer;
    final Object valueToCheck;

    DelegatingJsonVerifiable(JsonVerifiable delegate, LinkedList<String> methodsBuffer, Object valueToCheck) {
        this.delegate = delegate;
        this.methodsBuffer = new LinkedList<String>(methodsBuffer);
        this.valueToCheck = valueToCheck;
    }

    DelegatingJsonVerifiable(JsonVerifiable delegate, LinkedList<String> methodsBuffer) {
        this.delegate = delegate;
        this.methodsBuffer = new LinkedList<String>(methodsBuffer);
        this.valueToCheck = null;
    }

    DelegatingJsonVerifiable(JsonVerifiable delegate) {
        this.delegate = delegate;
        this.methodsBuffer = new LinkedList();
        this.valueToCheck = null;
    }

    private static String stringWithEscapedQuotes(Object object) {
        String stringValue = object.toString();
        return stringValue.replaceAll("\"", "\\\\\"");
    }

    private static String wrapValueWithQuotes(Object value) {
        return value instanceof String ? "\"" + DelegatingJsonVerifiable.stringWithEscapedQuotes(value) + "\"" : value.toString();
    }

    private void appendMethodWithValue(String methodName, Object value) {
        this.methodsBuffer.offer("." + methodName + "(" + value + ")");
    }

    private void appendMethodWithQuotedValue(String methodName, Object value) {
        this.appendMethodWithValue(methodName, DelegatingJsonVerifiable.wrapValueWithQuotes(value));
    }

    @Override
    public MethodBufferingJsonVerifiable contains(Object value) {
        FinishedDelegatingJsonVerifiable verifiable = new FinishedDelegatingJsonVerifiable(this.delegate.jsonPath(), this.delegate.contains(value), this.methodsBuffer);
        super.appendMethodWithQuotedValue("contains", value);
        if (this.isAssertingAValueInArray()) {
            verifiable.methodsBuffer.offer(".value()");
        }
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable field(Object value) {
        Object valueToPut = value instanceof ShouldTraverse ? ((ShouldTraverse)value).value : value;
        Object wrappedValue = this.wrapInBrackets(valueToPut);
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.field(wrappedValue), this.methodsBuffer, value);
        if (this.delegate.isIteratingOverArray() && !(value instanceof ShouldTraverse)) {
            verifiable.appendMethodWithQuotedValue("contains", wrappedValue);
        } else {
            verifiable.appendMethodWithQuotedValue("field", wrappedValue);
        }
        return verifiable;
    }

    public MethodBufferingJsonVerifiable field(String ... strings) {
        MethodBufferingJsonVerifiable verifiable = null;
        for (String string : strings) {
            verifiable = verifiable == null ? this.field((Object)string) : verifiable.field(string);
        }
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable array(Object value) {
        Object valueToPut = this.wrapInBrackets(value);
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.array(valueToPut), this.methodsBuffer, value);
        verifiable.appendMethodWithQuotedValue("array", valueToPut);
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable arrayField(Object value) {
        Object valueToPut = this.wrapInBrackets(value);
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.field(valueToPut).arrayField(), this.methodsBuffer, value);
        verifiable.appendMethodWithQuotedValue("array", valueToPut);
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable arrayField() {
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.arrayField(), this.methodsBuffer);
        verifiable.methodsBuffer.offer(".arrayField()");
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable array() {
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.array(), this.methodsBuffer);
        verifiable.methodsBuffer.offer(".array()");
        return verifiable;
    }

    public JsonVerifiable elementWithIndex(int i) {
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.elementWithIndex(i), this.methodsBuffer);
        this.methodsBuffer.offer(".elementWithIndex(" + i + ")");
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable iterationPassingArray() {
        return new DelegatingJsonVerifiable(this.delegate, this.methodsBuffer);
    }

    @Override
    public MethodBufferingJsonVerifiable isEqualTo(String value) {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.jsonPath(), this.delegate.isEqualTo(value), this.methodsBuffer, value);
        if (this.delegate.isAssertingAValueInArray() && readyToCheck.methodsBuffer.peekLast().equals(".arrayField()")) {
            super.appendMethodWithQuotedValue("isEqualTo", this.escapedHackedJavaText(value));
            readyToCheck.methodsBuffer.offer(".value()");
        } else if (this.delegate.isAssertingAValueInArray() && !readyToCheck.methodsBuffer.peekLast().contains("array")) {
            readyToCheck.methodsBuffer.offer(".value()");
        } else {
            super.appendMethodWithQuotedValue("isEqualTo", this.escapedHackedJavaText(value));
        }
        return readyToCheck;
    }

    @Override
    public MethodBufferingJsonVerifiable isEqualTo(Object value) {
        if (value == null) {
            return this.isNull();
        }
        return this.isEqualTo(value.toString());
    }

    @Override
    public MethodBufferingJsonVerifiable isEqualTo(Number value) {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.jsonPath(), this.delegate.isEqualTo(value), this.methodsBuffer, value);
        String last = readyToCheck.methodsBuffer.peekLast();
        boolean containsAMatcher = this.containsAnyMatcher(last);
        if (this.delegate.isAssertingAValueInArray() && containsAMatcher) {
            readyToCheck.methodsBuffer.offer(".value()");
        } else {
            super.appendMethodWithValue("isEqualTo", value instanceof Long ? String.valueOf(value).concat("L") : String.valueOf(value));
        }
        return readyToCheck;
    }

    private boolean containsAnyMatcher(String string) {
        return string.contains("isEqualTo") || string.contains("matches") || string.contains("isNull");
    }

    @Override
    public MethodBufferingJsonVerifiable isNull() {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.jsonPath(), this.delegate.isNull(), this.methodsBuffer);
        readyToCheck.methodsBuffer.offer(".isNull()");
        return readyToCheck;
    }

    @Override
    public MethodBufferingJsonVerifiable isEmpty() {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.jsonPath(), this.delegate.isEmpty(), this.methodsBuffer);
        readyToCheck.methodsBuffer.offer(".isEmpty()");
        return readyToCheck;
    }

    @Override
    public MethodBufferingJsonVerifiable isInstanceOf(Class clazz) throws IllegalStateException {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.jsonPath(), this.delegate.isInstanceOf(clazz), this.methodsBuffer);
        readyToCheck.methodsBuffer.offer(".isInstanceOf(" + clazz.getName() + ")");
        return readyToCheck;
    }

    @Override
    public MethodBufferingJsonVerifiable matches(String value) {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.jsonPath(), this.delegate.matches(value), this.methodsBuffer, this.compilePattern(value));
        if (this.delegate.isAssertingAValueInArray()) {
            super.appendMethodWithQuotedValue("matches", this.escapedHackedJavaText(value));
            readyToCheck.methodsBuffer.offer(".value()");
        } else {
            super.appendMethodWithQuotedValue("matches", this.escapedHackedJavaText(value));
        }
        return readyToCheck;
    }

    private Object compilePattern(String value) {
        try {
            return Pattern.compile(value);
        }
        catch (Exception e) {
            log.warn((Object)("Exception occurred while trying to compile the pattern [" + value + "]. Will return the value explicitly. Hopefully, you know what you're doing..."));
            return value;
        }
    }

    private String escapedHackedJavaText(String value) {
        return StringEscapeUtils.escapeJava((String)value).replace("\\\"", "\"");
    }

    @Override
    public MethodBufferingJsonVerifiable isEqualTo(Boolean value) {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.jsonPath(), this.delegate.isEqualTo(value), this.methodsBuffer, value);
        if (this.delegate.isAssertingAValueInArray()) {
            readyToCheck.methodsBuffer.offer(".value()");
        } else {
            super.appendMethodWithValue("isEqualTo", String.valueOf(value));
        }
        return readyToCheck;
    }

    @Override
    public MethodBufferingJsonVerifiable value() {
        return new FinishedDelegatingJsonVerifiable(this.delegate, this.methodsBuffer);
    }

    @Override
    public String keyBeforeChecking() {
        return this.delegate.jsonPath();
    }

    @Override
    public Object valueBeforeChecking() {
        return this.valueToCheck;
    }

    @Override
    public boolean assertsSize() {
        for (String s : this.methodsBuffer) {
            if (!s.contains(".hasSize(") && !s.contains(".isEmpty()")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean assertsConcreteValue() {
        for (String s : this.methodsBuffer) {
            if (!FIELD_PATTERN.matcher(s).matches() && !ARRAY_PATTERN.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public JsonVerifiable withoutThrowingException() {
        return this.delegate.withoutThrowingException();
    }

    public String jsonPath() {
        return this.delegate.jsonPath();
    }

    public void matchesJsonPath(String s) {
        this.delegate.matchesJsonPath(s);
    }

    public JsonVerifiable hasSize(int size) {
        FinishedDelegatingJsonVerifiable verifiable = new FinishedDelegatingJsonVerifiable(this.delegate.jsonPath(), this.delegate.hasSize(size), this.methodsBuffer);
        verifiable.methodsBuffer.offer(".hasSize(" + size + ")");
        return verifiable;
    }

    public boolean isIteratingOverNamelessArray() {
        return this.delegate.isIteratingOverNamelessArray();
    }

    public boolean isIteratingOverArray() {
        return this.delegate.isIteratingOverArray();
    }

    public boolean isAssertingAValueInArray() {
        return this.delegate.isAssertingAValueInArray();
    }

    private Object wrapInBrackets(Object name) {
        if (name instanceof Number) {
            return name;
        }
        return "['" + name.toString() + "']";
    }

    @Override
    public String method() {
        return this.createMethodString();
    }

    private String createMethodString() {
        LinkedList<String> queue = new LinkedList<String>(this.methodsBuffer);
        StringBuilder stringBuffer = new StringBuilder();
        while (!queue.isEmpty()) {
            stringBuffer.append(queue.remove());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingJsonVerifiable that = (DelegatingJsonVerifiable)o;
        return this.methodsBuffer.toString().equals(that.methodsBuffer.toString());
    }

    public int hashCode() {
        int result = this.methodsBuffer.toString().hashCode();
        return 31 * result;
    }

    public String toString() {
        return "DelegatingJsonVerifiable{delegate=\n" + this.delegate + ", methodsBuffer=" + this.methodsBuffer + '}';
    }

    public <T> T read(Class<T> aClass) {
        return (T)this.delegate.read(aClass);
    }
}

