/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.stream.DefaultChannels;
import org.springframework.cloud.contract.verifier.messaging.stream.DestinationResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.PollableChannel;

class StreamPollableChannelMessageReceiver
implements MessageVerifierReceiver<Message<?>> {
    private static final Log log = LogFactory.getLog(StreamPollableChannelMessageReceiver.class);
    private final ApplicationContext context;
    private final DestinationResolver destinationResolver;

    StreamPollableChannelMessageReceiver(ApplicationContext context) {
        this.context = context;
        this.destinationResolver = new DestinationResolver(context);
    }

    @Override
    public Message<?> receive(String destination, long timeout, TimeUnit timeUnit) {
        try {
            PollableChannel messageChannel = (PollableChannel)this.context.getBean(this.destinationResolver.resolvedDestination(destination, DefaultChannels.INPUT), PollableChannel.class);
            return messageChannel.receive(timeUnit.toMillis(timeout));
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to read a message from  a channel with name [" + destination + "]"), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Message<?> receive(String destination) {
        return this.receive(destination, 5L, TimeUnit.SECONDS);
    }
}

