/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.file;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.io.File;
import java.util.Collection;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.Input;
import org.springframework.cloud.contract.spec.internal.OutputMessage;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.ContentUtils;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.util.Assert;

@EqualsAndHashCode(excludes={"contractMetadata"})
@ToString(excludes={"contractMetadata"})
public class SingleContractMetadata
implements GroovyObject {
    private static final Log log;
    private final ContractMetadata contractMetadata;
    private final File stubsFile;
    private final Contract contract;
    private final Collection<Contract> allContracts;
    private final String definedInputStubContentType;
    private final ContentType inputStubContentType;
    private final ContentType evaluatedInputStubContentType;
    private final String definedOutputStubContentType;
    private final ContentType outputStubContentType;
    private final ContentType evaluatedOutputStubContentType;
    private final String definedInputTestContentType;
    private final ContentType inputTestContentType;
    private final ContentType evaluatedInputTestContentType;
    private final String definedOutputTestContentType;
    private final ContentType outputTestContentType;
    private final ContentType evaluatedOutputTestContentType;
    private final boolean http;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public SingleContractMetadata(Contract currentContract, ContractMetadata contractMetadata) {
        ContractMetadata contractMetadata2;
        boolean bl;
        ContentType contentType;
        ContentType contentType2;
        ContentType contentType3;
        ContentType contentType4;
        ContentType contentType5;
        ContentType contentType6;
        ContentType contentType7;
        ContentType contentType8;
        Contract contract;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Collection<Contract> collection = contractMetadata.getConvertedContract();
        this.allContracts = collection;
        this.contract = contract = currentContract;
        Assert.notNull((Object)currentContract, (String)"Contract must not be null");
        Headers inputHeaders = this.inputHeaders(currentContract);
        DslProperty inputBody = this.inputBody(currentContract);
        Headers outputHeaders = this.outputHeaders(currentContract);
        DslProperty outputBody = this.outputBody(currentContract);
        Header inputContentType = this.contentTypeHeader(inputHeaders);
        Header outputContentType = this.contentTypeHeader(outputHeaders);
        String string = inputContentType != null ? inputContentType.getServerValue() : "";
        this.definedInputTestContentType = ShortTypeHandling.castToString((Object)string);
        this.evaluatedInputTestContentType = contentType8 = this.tryToEvaluateTestContentType(inputHeaders, inputBody);
        this.inputTestContentType = contentType7 = inputBody != null ? this.evaluatedInputTestContentType : ContentType.UNKNOWN;
        String string2 = outputContentType != null ? outputContentType.getServerValue() : "";
        this.definedOutputTestContentType = ShortTypeHandling.castToString((Object)string2);
        this.evaluatedOutputTestContentType = contentType6 = this.tryToEvaluateTestContentType(outputHeaders, outputBody);
        this.outputTestContentType = contentType5 = outputBody != null ? this.evaluatedOutputTestContentType : ContentType.UNKNOWN;
        String string3 = inputContentType != null ? inputContentType.getClientValue() : "";
        this.definedInputStubContentType = ShortTypeHandling.castToString((Object)string3);
        this.evaluatedInputStubContentType = contentType4 = this.tryToEvaluateStubContentType(inputHeaders, inputBody);
        this.inputStubContentType = contentType3 = inputBody != null ? this.evaluatedInputStubContentType : ContentType.UNKNOWN;
        String string4 = outputContentType != null ? outputContentType.getClientValue() : "";
        this.definedOutputStubContentType = ShortTypeHandling.castToString((Object)string4);
        this.evaluatedOutputStubContentType = contentType2 = this.tryToEvaluateStubContentType(outputHeaders, outputBody);
        this.outputStubContentType = contentType = outputBody != null ? this.evaluatedOutputStubContentType : ContentType.UNKNOWN;
        this.http = bl = currentContract.getRequest() != null;
        this.contractMetadata = contractMetadata2 = contractMetadata;
        File file = contractMetadata.getPath() != null ? contractMetadata.getPath().toFile() : null;
        this.stubsFile = (File)ScriptBytecodeAdapter.castToType((Object)file, File.class);
    }

    private Header contentTypeHeader(Headers headers) {
        public final class _contentTypeHeader_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _contentTypeHeader_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object header) {
                return "Content-Type".equalsIgnoreCase(((Header)header).getName());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _contentTypeHeader_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Header)ScriptBytecodeAdapter.castToType(headers == null ? null : headers.getEntries().stream().filter((Predicate)ScriptBytecodeAdapter.castToType((Object)((Object)new _contentTypeHeader_closure1(this, this)), Predicate.class)).findFirst().orElse(null), Header.class);
    }

    private ContentType tryToEvaluateStubContentType(Headers mainHeaders, DslProperty body) {
        DslProperty dslProperty = body;
        ContentType contentType = ContentUtils.evaluateClientSideContentType(mainHeaders, dslProperty != null ? dslProperty.getClientValue() : null);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.DEFINED)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.UNKNOWN))) {
            DslProperty dslProperty2 = body;
            return ContentUtils.evaluateServerSideContentType(mainHeaders, dslProperty2 != null ? dslProperty2.getServerValue() : null);
        }
        return contentType;
    }

    private ContentType tryToEvaluateTestContentType(Headers mainHeaders, DslProperty body) {
        DslProperty dslProperty = body;
        ContentType contentType = ContentUtils.evaluateClientSideContentType(mainHeaders, dslProperty != null ? dslProperty.getServerValue() : null);
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.DEFINED)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)contentType), (Object)((Object)ContentType.UNKNOWN))) {
            DslProperty dslProperty2 = body;
            return ContentUtils.evaluateServerSideContentType(mainHeaders, dslProperty2 != null ? dslProperty2.getClientValue() : null);
        }
        return contentType;
    }

    public boolean isJson() {
        return ScriptBytecodeAdapter.compareEqual((Object)((Object)this.inputTestContentType), (Object)((Object)ContentType.JSON)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.outputTestContentType), (Object)((Object)ContentType.JSON)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.inputStubContentType), (Object)((Object)ContentType.JSON)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.outputStubContentType), (Object)((Object)ContentType.JSON));
    }

    public boolean evaluatesToJson() {
        return this.isJson() || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.evaluatedInputTestContentType), (Object)((Object)ContentType.JSON)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.evaluatedOutputTestContentType), (Object)((Object)ContentType.JSON)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.evaluatedInputStubContentType), (Object)((Object)ContentType.JSON)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.evaluatedOutputStubContentType), (Object)((Object)ContentType.JSON));
    }

    public boolean isIgnored() {
        return this.contract.getIgnored() || this.contract.getInProgress() || this.contractMetadata.getIgnored();
    }

    public boolean isXml() {
        return ScriptBytecodeAdapter.compareEqual((Object)((Object)this.inputTestContentType), (Object)((Object)ContentType.XML)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.outputTestContentType), (Object)((Object)ContentType.XML)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.inputStubContentType), (Object)((Object)ContentType.XML)) || ScriptBytecodeAdapter.compareEqual((Object)((Object)this.outputStubContentType), (Object)((Object)ContentType.XML));
    }

    public boolean isHttp() {
        return this.http;
    }

    public boolean isInProgress() {
        return this.contract.isInProgress();
    }

    public boolean isMessaging() {
        return !this.isHttp();
    }

    private DslProperty inputBody(Contract contract) {
        Input input;
        Request request = contract.getRequest();
        Body body = request != null ? request.getBody() : null;
        return DefaultTypeTransformation.booleanUnbox((Object)body) ? body : ((input = contract.getInput()) != null ? input.getMessageBody() : null);
    }

    private Headers inputHeaders(Contract contract) {
        Input input;
        Request request = contract.getRequest();
        Headers headers = request != null ? request.getHeaders() : null;
        return DefaultTypeTransformation.booleanUnbox((Object)headers) ? headers : ((input = contract.getInput()) != null ? input.getMessageHeaders() : null);
    }

    private DslProperty outputBody(Contract contract) {
        OutputMessage outputMessage;
        Response response = contract.getResponse();
        Body body = response != null ? response.getBody() : null;
        return DefaultTypeTransformation.booleanUnbox((Object)body) ? body : ((outputMessage = contract.getOutputMessage()) != null ? outputMessage.getBody() : null);
    }

    private Headers outputHeaders(Contract contract) {
        OutputMessage outputMessage;
        Response response = contract.getResponse();
        Headers headers = response != null ? response.getHeaders() : null;
        return DefaultTypeTransformation.booleanUnbox((Object)headers) ? headers : ((outputMessage = contract.getOutputMessage()) != null ? outputMessage.getHeaders() : null);
    }

    public String methodName() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.contract.getName())) {
            String name = NamesUtil.camelCase(NamesUtil.convertIllegalPackageChars(this.contract.getName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Overriding the default test name with [", (CharSequence)name), (CharSequence)"]"));
            }
            return name;
        }
        if (this.allContracts.size() > 1) {
            public final class _methodName_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _methodName_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)it, (Object)((SingleContractMetadata)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SingleContractMetadata.class)).getContract());
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _methodName_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            int index = DefaultGroovyMethods.findIndexOf(this.allContracts, (Closure)new _methodName_closure2(this, this));
            String name = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SingleContractMetadata.camelCasedMethodFromFileName(this.stubsFile), index}, new String[]{"", "_", ""}));
            if (log.isDebugEnabled()) {
                log.debug((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Scenario found. The method name will be [", (CharSequence)name), (CharSequence)"]"));
            }
            return name;
        }
        String name = SingleContractMetadata.camelCasedMethodFromFileName(this.stubsFile);
        if (log.isDebugEnabled()) {
            log.debug((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"The method name will be [", (CharSequence)name), (CharSequence)"]"));
        }
        return name;
    }

    private static String camelCasedMethodFromFileName(File stubsFile) {
        return NamesUtil.camelCase(NamesUtil.convertIllegalMethodNameChars(NamesUtil.toLastDot(NamesUtil.afterLast(stubsFile.getPath(), File.separator))));
    }

    @Generated
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (!(this.getContract() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getContract());
        }
        if (!(this.getDefinedInputStubContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getDefinedInputStubContentType());
        }
        if (!(this.getInputStubContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)((Object)this.getInputStubContentType()));
        }
        if (!(this.getEvaluatedInputStubContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)((Object)this.getEvaluatedInputStubContentType()));
        }
        if (!(this.getDefinedOutputStubContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getDefinedOutputStubContentType());
        }
        if (!(this.getOutputStubContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)((Object)this.getOutputStubContentType()));
        }
        if (!(this.getEvaluatedOutputStubContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)((Object)this.getEvaluatedOutputStubContentType()));
        }
        if (!(this.getDefinedInputTestContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getDefinedInputTestContentType());
        }
        if (!(this.getInputTestContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)((Object)this.getInputTestContentType()));
        }
        if (!(this.getEvaluatedInputTestContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)((Object)this.getEvaluatedInputTestContentType()));
        }
        if (!(this.getDefinedOutputTestContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)this.getDefinedOutputTestContentType());
        }
        if (!(this.getOutputTestContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)((Object)this.getOutputTestContentType()));
        }
        if (!(this.getEvaluatedOutputTestContentType() == this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)((Object)this.getEvaluatedOutputTestContentType()));
        }
        return _result;
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof SingleContractMetadata;
    }

    @Generated
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingleContractMetadata)) {
            return false;
        }
        SingleContractMetadata otherTyped = (SingleContractMetadata)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.getContract(), (Object)otherTyped.getContract())) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.getDefinedInputStubContentType(), (Object)otherTyped.getDefinedInputStubContentType())) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)this.getInputStubContentType()), (Object)((Object)otherTyped.getInputStubContentType()))) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)this.getEvaluatedInputStubContentType()), (Object)((Object)otherTyped.getEvaluatedInputStubContentType()))) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.getDefinedOutputStubContentType(), (Object)otherTyped.getDefinedOutputStubContentType())) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)this.getOutputStubContentType()), (Object)((Object)otherTyped.getOutputStubContentType()))) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)this.getEvaluatedOutputStubContentType()), (Object)((Object)otherTyped.getEvaluatedOutputStubContentType()))) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.getDefinedInputTestContentType(), (Object)otherTyped.getDefinedInputTestContentType())) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)this.getInputTestContentType()), (Object)((Object)otherTyped.getInputTestContentType()))) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)this.getEvaluatedInputTestContentType()), (Object)((Object)otherTyped.getEvaluatedInputTestContentType()))) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.getDefinedOutputTestContentType(), (Object)otherTyped.getDefinedOutputTestContentType())) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)this.getOutputTestContentType()), (Object)((Object)otherTyped.getOutputTestContentType()))) {
            return false;
        }
        return !(!ScriptBytecodeAdapter.compareEqual((Object)((Object)this.getEvaluatedOutputTestContentType()), (Object)((Object)otherTyped.getEvaluatedOutputTestContentType())));
    }

    @Generated
    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("org.springframework.cloud.contract.verifier.file.SingleContractMetadata(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getContract()));
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            Boolean bl4;
            $toStringFirst = bl4 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getDefinedInputStubContentType()));
        Boolean bl5 = $toStringFirst;
        if (bl5 == null ? false : bl5) {
            Boolean bl6;
            $toStringFirst = bl6 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)((Object)this.getInputStubContentType())));
        Boolean bl7 = $toStringFirst;
        if (bl7 == null ? false : bl7) {
            Boolean bl8;
            $toStringFirst = bl8 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)((Object)this.getEvaluatedInputStubContentType())));
        Boolean bl9 = $toStringFirst;
        if (bl9 == null ? false : bl9) {
            Boolean bl10;
            $toStringFirst = bl10 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getDefinedOutputStubContentType()));
        Boolean bl11 = $toStringFirst;
        if (bl11 == null ? false : bl11) {
            Boolean bl12;
            $toStringFirst = bl12 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)((Object)this.getOutputStubContentType())));
        Boolean bl13 = $toStringFirst;
        if (bl13 == null ? false : bl13) {
            Boolean bl14;
            $toStringFirst = bl14 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)((Object)this.getEvaluatedOutputStubContentType())));
        Boolean bl15 = $toStringFirst;
        if (bl15 == null ? false : bl15) {
            Boolean bl16;
            $toStringFirst = bl16 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getDefinedInputTestContentType()));
        Boolean bl17 = $toStringFirst;
        if (bl17 == null ? false : bl17) {
            Boolean bl18;
            $toStringFirst = bl18 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)((Object)this.getInputTestContentType())));
        Boolean bl19 = $toStringFirst;
        if (bl19 == null ? false : bl19) {
            Boolean bl20;
            $toStringFirst = bl20 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)((Object)this.getEvaluatedInputTestContentType())));
        Boolean bl21 = $toStringFirst;
        if (bl21 == null ? false : bl21) {
            Boolean bl22;
            $toStringFirst = bl22 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getDefinedOutputTestContentType()));
        Boolean bl23 = $toStringFirst;
        if (bl23 == null ? false : bl23) {
            Boolean bl24;
            $toStringFirst = bl24 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)((Object)this.getOutputTestContentType())));
        Boolean bl25 = $toStringFirst;
        if (bl25 == null ? false : bl25) {
            Boolean bl26;
            $toStringFirst = bl26 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)((Object)this.getEvaluatedOutputTestContentType())));
        Boolean bl27 = $toStringFirst;
        if (bl27 == null ? false : bl27) {
            Boolean bl28;
            $toStringFirst = bl28 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.http));
        Boolean bl29 = $toStringFirst;
        if (bl29 == null ? false : bl29) {
            Boolean bl30;
            $toStringFirst = bl30 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.isMessaging()));
        Boolean bl31 = $toStringFirst;
        if (bl31 == null ? false : bl31) {
            Boolean bl32;
            $toStringFirst = bl32 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.isInProgress()));
        Boolean bl33 = $toStringFirst;
        if (bl33 == null ? false : bl33) {
            Boolean bl34;
            $toStringFirst = bl34 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.isXml()));
        Boolean bl35 = $toStringFirst;
        if (bl35 == null ? false : bl35) {
            Boolean bl36;
            $toStringFirst = bl36 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.isIgnored()));
        Boolean bl37 = $toStringFirst;
        if (bl37 == null ? false : bl37) {
            Boolean bl38;
            $toStringFirst = bl38 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.isJson()));
        _result.append(")");
        return _result.toString();
    }

    public static /* synthetic */ Contract pfaccess$0(SingleContractMetadata $that) {
        return $that.getContract();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SingleContractMetadata.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        SingleContractMetadata.log = log = LogFactory.getLog(SingleContractMetadata.class);
    }

    @Generated
    public final ContractMetadata getContractMetadata() {
        return this.contractMetadata;
    }

    @Generated
    public final Contract getContract() {
        return this.contract;
    }

    @Generated
    public final String getDefinedInputStubContentType() {
        return this.definedInputStubContentType;
    }

    @Generated
    public final ContentType getInputStubContentType() {
        return this.inputStubContentType;
    }

    @Generated
    public final ContentType getEvaluatedInputStubContentType() {
        return this.evaluatedInputStubContentType;
    }

    @Generated
    public final String getDefinedOutputStubContentType() {
        return this.definedOutputStubContentType;
    }

    @Generated
    public final ContentType getOutputStubContentType() {
        return this.outputStubContentType;
    }

    @Generated
    public final ContentType getEvaluatedOutputStubContentType() {
        return this.evaluatedOutputStubContentType;
    }

    @Generated
    public final String getDefinedInputTestContentType() {
        return this.definedInputTestContentType;
    }

    @Generated
    public final ContentType getInputTestContentType() {
        return this.inputTestContentType;
    }

    @Generated
    public final ContentType getEvaluatedInputTestContentType() {
        return this.evaluatedInputTestContentType;
    }

    @Generated
    public final String getDefinedOutputTestContentType() {
        return this.definedOutputTestContentType;
    }

    @Generated
    public final ContentType getOutputTestContentType() {
        return this.outputTestContentType;
    }

    @Generated
    public final ContentType getEvaluatedOutputTestContentType() {
        return this.evaluatedOutputTestContentType;
    }
}

