/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.spec.ContractTemplate;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyAssertionLineCreator;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.JsonBodyVerificationBuilder;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.template.HandlebarsTemplateProcessor;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.util.StringUtils;

class GenericJsonBodyThen
implements Then {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final BodyParser bodyParser;
    private final BodyAssertionLineCreator bodyAssertionLineCreator;
    private final TemplateProcessor templateProcessor;
    private final ContractTemplate contractTemplate;
    private final ComparisonBuilder comparisonBuilder;

    GenericJsonBodyThen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData, BodyParser bodyParser, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.bodyParser = bodyParser;
        this.comparisonBuilder = comparisonBuilder;
        this.bodyAssertionLineCreator = new BodyAssertionLineCreator(blockBuilder, metaData, this.bodyParser.byteArrayString(), this.comparisonBuilder);
        this.generatedClassMetaData = metaData;
        this.templateProcessor = new HandlebarsTemplateProcessor();
        this.contractTemplate = new HandlebarsTemplateProcessor();
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata metadata) {
        BodyMatchers bodyMatchers = this.bodyParser.responseBodyMatchers(metadata);
        Object convertedResponseBody = this.bodyParser.convertResponseBody(metadata);
        ContentType contentType = metadata.getOutputTestContentType();
        if (ContentType.TEXT != contentType && ContentType.FORM != contentType && ContentType.DEFINED != contentType) {
            boolean dontParseStrings = contentType == ContentType.JSON && convertedResponseBody instanceof Map;
            Function<Object, Object> parsingClosure = dontParseStrings ? Function.identity() : MapConverter.JSON_PARSING_FUNCTION;
            convertedResponseBody = MapConverter.getTestSideValues(convertedResponseBody, parsingClosure);
        } else {
            convertedResponseBody = StringEscapeUtils.escapeJava((String)convertedResponseBody.toString());
        }
        this.addJsonBodyVerification(metadata, convertedResponseBody, bodyMatchers);
        return this;
    }

    private void addJsonBodyVerification(SingleContractMetadata contractMetadata, Object responseBody, BodyMatchers bodyMatchers) {
        JsonBodyVerificationBuilder jsonBodyVerificationBuilder = new JsonBodyVerificationBuilder(this.generatedClassMetaData.configProperties.getAssertJsonSize(), this.templateProcessor, this.contractTemplate, contractMetadata.getContract(), Optional.of(this.blockBuilder.getLineEnding()), this.bodyParser::postProcessJsonPath);
        Object convertedResponseBody = jsonBodyVerificationBuilder.addJsonResponseBodyCheck(this.blockBuilder, responseBody, bodyMatchers, this.bodyParser.responseAsString(), this.generatedClassMetaData.configProperties.getTestFramework() != TestFramework.SPOCK);
        if (!(convertedResponseBody instanceof Map || convertedResponseBody instanceof List || convertedResponseBody instanceof ExecutionProperty)) {
            this.simpleTextResponseBodyCheck(contractMetadata, convertedResponseBody);
        }
        this.processBodyElement("", "", convertedResponseBody);
    }

    private void processBodyElement(String oldProp, String property, Object value) {
        String mergedProp;
        String propDiff = this.subtract(property, oldProp);
        String prop = this.wrappedWithBracketsForDottedProp(propDiff);
        String string = mergedProp = StringUtils.hasText((String)property) ? oldProp + "." + prop : "";
        if (value instanceof ExecutionProperty) {
            this.processBodyElement(mergedProp, (ExecutionProperty)value);
        } else if (value instanceof Map.Entry) {
            this.processBodyElement(mergedProp, (Map.Entry)value);
        } else if (value instanceof Map) {
            this.processBodyElement(mergedProp, (Map)value);
        } else if (value instanceof List) {
            this.processBodyElement(mergedProp, (List)value);
        }
    }

    private void processBodyElement(String property, ExecutionProperty exec) {
        this.blockBuilder.addLineWithEnding(exec.insertValue(this.bodyParser.postProcessJsonPath("parsedJson.read(\"$" + property + "\")")));
    }

    private void processBodyElement(String property, Map.Entry entry) {
        this.processBodyElement(property, this.getMapKeyReferenceString(property, entry), entry.getValue());
    }

    private void processBodyElement(String property, Map map) {
        map.entrySet().forEach(o -> this.processBodyElement(property, (Map.Entry)o));
    }

    private void processBodyElement(String property, List list) {
        Iterator iterator = list.iterator();
        int index = -1;
        while (iterator.hasNext()) {
            Object listElement = iterator.next();
            String prop = this.getPropertyInListString(property, ++index);
            this.processBodyElement(property, prop, listElement);
        }
    }

    private String getPropertyInListString(String property, Integer listIndex) {
        return property + "[" + listIndex + "]";
    }

    private String getMapKeyReferenceString(String property, Map.Entry entry) {
        return this.provideProperJsonPathNotation(property) + "." + entry.getKey();
    }

    private String provideProperJsonPathNotation(String property) {
        return property.replaceAll("(get\\(\\\\\")(.*)(\\\\\"\\))", "$2");
    }

    private String wrappedWithBracketsForDottedProp(String key) {
        String remindingKey = this.trailingKey(key);
        if (remindingKey.contains(".")) {
            return "['" + remindingKey + "']";
        }
        return remindingKey;
    }

    private String trailingKey(String key) {
        if (key.startsWith(".")) {
            return key.substring(1);
        }
        return key;
    }

    private String subtract(String self, String text) {
        int index = self.indexOf(text);
        if (index == -1) {
            return self;
        }
        int end = index + text.length();
        if (self.length() > end) {
            return self.substring(0, index) + self.substring(end);
        }
        return self.substring(0, index);
    }

    private void simpleTextResponseBodyCheck(SingleContractMetadata metadata, Object convertedResponseBody) {
        this.blockBuilder.addLineWithEnding(this.getSimpleResponseBodyString(this.bodyParser.responseAsString()));
        this.bodyAssertionLineCreator.appendBodyAssertionLine(metadata, "", convertedResponseBody);
        this.blockBuilder.addEndingIfNotPresent();
    }

    private String getSimpleResponseBodyString(String responseString) {
        return "String responseBody = " + responseString + this.blockBuilder.getLineEnding();
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        ContentType outputTestContentType = metadata.getOutputTestContentType();
        return ContentType.JSON == outputTestContentType || this.mostLikelyJson(outputTestContentType, metadata);
    }

    private boolean mostLikelyJson(ContentType outputTestContentType, SingleContractMetadata metadata) {
        return ContentType.DEFINED == outputTestContentType && metadata.evaluatesToJson();
    }
}

