/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.RepoRoot;
import org.springframework.cloud.contract.stubrunner.RepoRoots;
import org.springframework.cloud.contract.stubrunner.ResourceResolver;
import org.springframework.cloud.contract.stubrunner.ResourceResolvingStubDownloader;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerPropertyUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

class StubsStubDownloader
implements StubDownloader {
    private static final Log log = LogFactory.getLog(StubsStubDownloader.class);
    private static final String STUBS_FIND_PRODUCER_PROPERTY = "stubs.find-producer";
    private static final String LATEST_VERSION = "+";
    private final StubRunnerOptions stubRunnerOptions;

    StubsStubDownloader(StubRunnerOptions stubRunnerOptions) {
        this.stubRunnerOptions = stubRunnerOptions;
    }

    @Override
    public Map.Entry<StubConfiguration, File> downloadAndUnpackStubJar(StubConfiguration stubConfiguration) {
        boolean shouldFindProducer = this.shouldFindProducer();
        if (!shouldFindProducer) {
            String schemeSpecific = this.schemeSpecificPart();
            log.info((Object)("Stubs are present under [" + schemeSpecific + "]. Will copy them to a temporary directory."));
            return new ResourceResolvingStubDownloader(this.stubRunnerOptions, this::repoRootForSchemeSpecificPart, this::anyPattern).downloadAndUnpackStubJar(stubConfiguration);
        }
        return new ResourceResolvingStubDownloader(this.stubRunnerOptions, this::repoRoot, this::gavPattern).downloadAndUnpackStubJar(stubConfiguration);
    }

    private RepoRoots repoRootForSchemeSpecificPart(StubRunnerOptions stubRunnerOptions, StubConfiguration configuration) {
        Object specificPart = this.schemeSpecificPart();
        specificPart = ((String)specificPart).endsWith("/") ? specificPart : (String)specificPart + "/";
        specificPart = (String)specificPart + "**/*.*";
        return new RepoRoots((Collection<? extends RepoRoot>)Collections.singleton(new RepoRoot((String)specificPart)));
    }

    private Pattern anyPattern(StubConfiguration config) {
        return Pattern.compile(this.resolvePath() + "(.*)");
    }

    private String resolvePath() {
        String schemeSpecificPart = this.schemeSpecificPart();
        Resource resource = ResourceResolver.resource(schemeSpecificPart);
        if (resource != null) {
            try {
                return resource.getURL().getFile();
            }
            catch (IOException ex) {
                return schemeSpecificPart;
            }
        }
        return schemeSpecificPart;
    }

    private RepoRoots repoRoot(StubRunnerOptions stubRunnerOptions, StubConfiguration configuration) {
        String pathWithGroupAndArtifactId = "/" + configuration.getGroupId() + "/" + configuration.getArtifactId();
        String pathWithGroupAndArtifactIdSlashSeparated = "/" + configuration.getGroupId().replace(".", File.separator) + "/" + configuration.getArtifactId();
        String anyFileSuffix = "/**/*.*";
        RepoRoots roots = RepoRoots.asList(new RepoRoot(this.schemeSpecificPart() + pathWithGroupAndArtifactId, anyFileSuffix), new RepoRoot(this.schemeSpecificPart() + pathWithGroupAndArtifactIdSlashSeparated, anyFileSuffix), new RepoRoot(this.schemeSpecificPart() + anyFileSuffix));
        if (!this.latestVersionIsSet(configuration)) {
            String pathWithGAV = pathWithGroupAndArtifactId + "/" + configuration.getVersion();
            String pathWithSlashSeparatedGAV = pathWithGroupAndArtifactIdSlashSeparated + "/" + configuration.getVersion();
            roots.addAll(RepoRoots.asList(new RepoRoot(this.schemeSpecificPart() + pathWithGAV, anyFileSuffix), new RepoRoot(this.schemeSpecificPart() + pathWithSlashSeparatedGAV, anyFileSuffix)));
        }
        return roots;
    }

    private Pattern gavPattern(StubConfiguration config) {
        String version = config.getVersion();
        String ga = config.getGroupId() + "." + config.getArtifactId();
        String gav = this.latestVersionIsSet(config) ? ga : ga + "." + version;
        return Pattern.compile("^(.*)(" + gav + ")(.*)$");
    }

    private boolean latestVersionIsSet(StubConfiguration configuration) {
        return LATEST_VERSION.equals(configuration.getVersion());
    }

    private boolean shouldFindProducer() {
        Map<String, String> args = this.stubRunnerOptions.getProperties();
        String findProducer = StubRunnerPropertyUtils.getProperty(args, STUBS_FIND_PRODUCER_PROPERTY);
        return Boolean.parseBoolean(findProducer);
    }

    private String schemeSpecificPart() {
        try {
            String part = this.stubRunnerOptions.getStubRepositoryRoot().getURI().getSchemeSpecificPart();
            if (!StringUtils.hasText((String)part)) {
                return part;
            }
            return part.startsWith("//") ? part.substring(2) : part;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

