/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.ConditionalOnStubbedDiscoveryEnabled;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerDiscoveryClient;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerDiscoveryClientWrapper;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerReactiveDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={StubMapperProperties.class})
@ConditionalOnClass(value={DiscoveryClient.class})
@ConditionalOnProperty(value={"spring.cloud.contract.stubrunner.cloud.enabled"}, matchIfMissing=true)
public class StubRunnerSpringCloudAutoConfiguration {
    @Bean
    public StubRunnerDiscoveryClientWrapper stubRunnerDiscoveryClientWrapper(BeanFactory beanFactory) {
        return new StubRunnerDiscoveryClientWrapper(beanFactory);
    }

    @Bean
    @ConditionalOnStubbedDiscoveryEnabled
    @ConditionalOnProperty(value={"spring.cloud.contract.stubrunner.cloud.delegate.enabled"}, havingValue="false", matchIfMissing=true)
    @Order(value=-2147483648)
    public DiscoveryClient noOpStubRunnerDiscoveryClient(StubFinder stubFinder, StubMapperProperties stubMapperProperties) {
        return new StubRunnerDiscoveryClient(stubFinder, stubMapperProperties);
    }

    @Bean
    @ConditionalOnStubbedDiscoveryEnabled
    @ConditionalOnProperty(value={"spring.cloud.contract.stubrunner.cloud.delegate.enabled"}, havingValue="false", matchIfMissing=true)
    @Order(value=-2147483648)
    public ReactiveDiscoveryClient noOpStubRunnerReactiveDiscoveryClient(StubFinder stubFinder, StubMapperProperties stubMapperProperties) {
        return new StubRunnerReactiveDiscoveryClient(stubFinder, stubMapperProperties);
    }
}

