/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.provider.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.security.ClientAuthenticator;
import com.github.tomakehurst.wiremock.security.NoClientAuthenticator;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.stubrunner.HttpServerStubConfiguration;
import org.springframework.cloud.contract.stubrunner.HttpServerStubConfigurer;
import org.springframework.cloud.contract.stubrunner.provider.wiremock.PortAndMappings;
import org.springframework.cloud.contract.verifier.builder.handlebars.HandlebarsEscapeHelper;
import org.springframework.cloud.contract.verifier.builder.handlebars.HandlebarsJsonPathHelper;
import org.springframework.cloud.contract.verifier.dsl.wiremock.DefaultResponseTransformer;
import org.springframework.cloud.contract.verifier.dsl.wiremock.SpringCloudContractRequestMatcher;
import org.springframework.cloud.contract.verifier.dsl.wiremock.WireMockExtensions;
import org.springframework.cloud.contract.wiremock.WireMockSpring;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import wiremock.com.github.jknack.handlebars.Helper;

public class WireMockHttpServerStub
implements HttpServerStub {
    static final Map<WireMockHttpServerStub, PortAndMappings> SERVERS = new ConcurrentHashMap<WireMockHttpServerStub, PortAndMappings>();
    private static final Log log = LogFactory.getLog(WireMockHttpServerStub.class);
    private static final int INVALID_PORT = -1;
    private WireMockServer wireMockServer;
    private boolean https = false;
    private WireMockConfiguration wireMockConfiguration;

    private WireMockConfiguration config() {
        if (ClassUtils.isPresent((String)"org.springframework.cloud.contract.wiremock.WireMockSpring", null)) {
            return WireMockSpring.options().extensions(this.responseTransformers());
        }
        return new WireMockConfiguration().extensions(this.responseTransformers());
    }

    private Extension[] responseTransformers() {
        List wireMockExtensions = SpringFactoriesLoader.loadFactories(WireMockExtensions.class, null);
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        if (!wireMockExtensions.isEmpty()) {
            for (WireMockExtensions wireMockExtension : wireMockExtensions) {
                extensions.addAll(wireMockExtension.extensions());
            }
        } else {
            extensions.addAll(Arrays.asList(new DefaultResponseTransformer(), new SpringCloudContractRequestMatcher()));
        }
        return extensions.toArray(new Extension[extensions.size()]);
    }

    private Map<String, Helper<?>> helpers() {
        HashMap helpers = new HashMap();
        helpers.put("jsonpath", (Helper<?>)new HandlebarsJsonPathHelper());
        helpers.put("escapejsonbody", (Helper<?>)new HandlebarsEscapeHelper());
        return helpers;
    }

    @Override
    public int port() {
        return this.isRunning() ? (this.https ? this.wireMockServer.httpsPort() : this.wireMockServer.port()) : -1;
    }

    @Override
    public boolean isRunning() {
        return this.wireMockServer != null && this.wireMockServer.isRunning();
    }

    @Override
    public HttpServerStub start(HttpServerStubConfiguration configuration) {
        if (this.isRunning()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("The server is already running at port [" + this.port() + "]"));
            }
            return this;
        }
        int port = configuration.port;
        WireMockConfiguration wireMockConfiguration = this.config().port(port).notifier((Notifier)new Slf4jNotifier(true));
        if (configuration.configurer.isAccepted(wireMockConfiguration)) {
            HttpServerStubConfigurer configurer = configuration.configurer;
            wireMockConfiguration = configurer.configure(wireMockConfiguration, configuration);
        }
        this.wireMockConfiguration = wireMockConfiguration;
        this.https = wireMockConfiguration.httpsSettings().enabled();
        port = this.https ? wireMockConfiguration.httpsSettings().port() : wireMockConfiguration.portNumber();
        this.wireMockServer = new WireMockServer((Options)wireMockConfiguration);
        this.wireMockServer.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("For " + configuration.toColonSeparatedDependencyNotation() + " Started WireMock at [" + (this.https ? "https" : "http") + "] port [" + port + "]"));
        }
        this.cacheStubServer(configuration.randomPort, port);
        return this;
    }

    @Override
    public int httpsPort() {
        return this.https ? this.port() : -1;
    }

    @Override
    public HttpServerStub reset() {
        this.wireMockServer.resetAll();
        return this;
    }

    private void cacheStubServer(boolean random, int port) {
        SERVERS.put(this, new PortAndMappings(random, port, new ArrayList<StubMapping>()));
    }

    @Override
    public HttpServerStub stop() {
        if (!this.isRunning()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Trying to stop a non started server!");
            }
            return this;
        }
        this.wireMockServer.stop();
        return this;
    }

    @Override
    public HttpServerStub registerMappings(Collection<File> stubFiles) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Server not started!");
        }
        this.registerStubMappings(stubFiles);
        return this;
    }

    @Override
    public String registeredMappings() {
        ArrayList<String> mappings = new ArrayList<String>();
        for (StubMapping stubMapping : this.wireMockServer.getStubMappings()) {
            mappings.add(stubMapping.toString());
        }
        return this.jsonArrayOfMappings(mappings);
    }

    private String jsonArrayOfMappings(Collection<String> mappings) {
        return "[" + StringUtils.collectionToDelimitedString(mappings, (String)",\n") + "]";
    }

    @Override
    public boolean isAccepted(File file) {
        return file.getName().endsWith(".json") && this.validMapping(file);
    }

    private boolean validMapping(File file) {
        try {
            this.getMapping(file);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    StubMapping getMapping(File file) {
        StubMapping stubMapping;
        block8: {
            InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                stubMapping = StubMapping.buildFrom((String)StreamUtils.copyToString((InputStream)stream, (Charset)Charset.forName("UTF-8")));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException | IOException e) {
                    throw new IllegalStateException("Cannot read file", e);
                }
            }
            stream.close();
        }
        return stubMapping;
    }

    private void registerStubMappings(Collection<File> stubFiles) {
        WireMock wireMock = this.wireMock();
        this.registerDefaultHealthChecks(wireMock);
        this.registerStubs(stubFiles, wireMock);
    }

    private WireMock wireMock() {
        String scheme = this.https ? "https" : "http";
        String host = "localhost";
        int port = this.port();
        String urlPathPrefix = "";
        String hostHeader = "";
        String proxyHost = this.wireMockConfiguration.proxyHostHeader();
        int proxyPort = this.wireMockConfiguration.proxyVia().port();
        NoClientAuthenticator authenticator = NoClientAuthenticator.noClientAuthenticator();
        return new WireMock(scheme, host, port, urlPathPrefix, hostHeader, proxyHost, proxyPort, (ClientAuthenticator)authenticator);
    }

    private void registerDefaultHealthChecks(WireMock wireMock) {
        this.registerHealthCheck(wireMock, "/ping");
        this.registerHealthCheck(wireMock, "/health");
    }

    private void registerStubs(Collection<File> sortedMappings, WireMock wireMock) {
        ArrayList<StubMapping> stubMappings = new ArrayList<StubMapping>();
        for (File mappingDescriptor : sortedMappings) {
            try {
                stubMappings.add(this.registerDescriptor(wireMock, mappingDescriptor));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Registered stub mappings from [" + mappingDescriptor + "]"));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Failed to register the stub mapping [" + mappingDescriptor + "]"), (Throwable)e);
            }
        }
        PortAndMappings portAndMappings = SERVERS.get(this);
        SERVERS.put(this, new PortAndMappings(portAndMappings.random, portAndMappings.port, stubMappings));
    }

    private StubMapping registerDescriptor(WireMock wireMock, File mappingDescriptor) {
        StubMapping mapping = this.getMapping(mappingDescriptor);
        wireMock.register(mapping);
        return mapping;
    }

    private void registerHealthCheck(WireMock wireMock, String url) {
        this.registerHealthCheck(wireMock, url, "OK");
    }

    private void registerHealthCheck(WireMock wireMock, String url, String body) {
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withBody(body).withStatus(200)));
    }

    static class Slf4jNotifier
    implements Notifier {
        private static final Logger log = LoggerFactory.getLogger((String)"WireMock");
        private final boolean verbose;

        Slf4jNotifier(boolean verbose) {
            this.verbose = verbose;
        }

        public void info(String message) {
            if (this.verbose) {
                log.info(message);
            }
        }

        public void error(String message) {
            log.error(message);
        }

        public void error(String message, Throwable t) {
            log.error(message, t);
        }
    }
}

