/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.loadbalancer;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.contract.stubrunner.spring.cloud.loadbalancer.ContractReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.contract.stubrunner.spring.cloud.loadbalancer.StubbedServiceInstance;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.core.ResolvableType;

class StubRunnerLoadBalancerClientFactory
extends LoadBalancerClientFactory
implements Closeable {
    private final BeanFactory beanFactory;

    StubRunnerLoadBalancerClientFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ReactiveLoadBalancer<ServiceInstance> getInstance(String serviceId) {
        return new ContractReactorServiceInstanceLoadBalancer(this.beanFactory, serviceId);
    }

    public <T> T getInstance(String name, Class<T> type) {
        return (T)this.getInstance(name);
    }

    public <T> T getInstance(String name, Class<?> clazz, Class<?> ... generics) {
        return (T)this.getInstance(name);
    }

    public <T> T getInstance(String name, ResolvableType type) {
        return (T)this.getInstance(name);
    }

    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        HashMap<String, ReactiveLoadBalancer<ServiceInstance>> map = new HashMap<String, ReactiveLoadBalancer<ServiceInstance>>();
        map.put(name, this.getInstance(name));
        return map;
    }

    @Override
    public void close() {
        StubbedServiceInstance.CACHE.clear();
    }
}

