/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.kafka;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.stubrunner.messaging.kafka.StubRunnerKafkaMessageSelector;
import org.springframework.cloud.contract.verifier.util.BodyExtractor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

class StubRunnerKafkaTransformer {
    private final StubRunnerKafkaMessageSelector selector;

    StubRunnerKafkaTransformer(List<Contract> groovyDsls) {
        this.selector = new StubRunnerKafkaMessageSelector(groovyDsls);
    }

    public Message<?> transform(Contract groovyDsl) {
        Object outputBody = this.outputBody(groovyDsl);
        Map headers = groovyDsl.getOutputMessage().getHeaders().asStubSideMap();
        Message newMessage = MessageBuilder.createMessage((Object)outputBody, (MessageHeaders)new MessageHeaders(headers));
        this.selector.updateCache(newMessage, groovyDsl);
        return newMessage;
    }

    private Object outputBody(Contract groovyDsl) {
        Object outputBody = BodyExtractor.extractClientValueFromBody((Object)groovyDsl.getOutputMessage().getBody());
        if (outputBody instanceof FromFileProperty) {
            FromFileProperty property = (FromFileProperty)outputBody;
            return property.asBytes();
        }
        return BodyExtractor.extractStubValueFrom((Object)outputBody);
    }
}

